<?php
namespace Woocommerce_Preorders;

class pluginUpdater
{
    public $plugin_file=WCPO_PLUGIN_FILE;
    public $responseObj;
    public $licenseMessage;
    public $showMessage=false;
    public $slug="preorders-for-woocommerce-pro";
    public function __construct()
    {
        $licenseKey=str_replace(' ', '', get_option("wc_preorders_license_key"));
        $liceEmail=get_option("wc_preorders_license_email", "");
        LicenseBase::addOnDelete(function () {
            delete_option("wc_preorders_license_key");
        });
        if (LicenseBase::CheckWPPlugin($licenseKey, $liceEmail, $this->licenseMessage, $this->responseObj, $this->plugin_file)) {
            add_action('elite_licenser_hook', function () {
                wp_enqueue_script('ps-widget', 'https://app.productstash.io/js/productstash-embed.js', ['jquery'], null, true);
                wp_add_inline_script(
                    'ps-widget',
                    'var ps_config = {
                        productId : "616fecbd-67ec-494d-92d2-81f8fd87e77c"
                    }'
                );
            });
            if (isset($_GET['preorder-lic-rm']) && $_GET['preorder-lic-rm'] == 1) {
                $mesg = '';
                LicenseBase::RemoveLicenseKey($this->plugin_file, $mesg);
                delete_option('wc_preorders_license_key');
                wp_safe_redirect(admin_url('admin.php?page=wc-settings&tab=settings_tab_preorders'));
            }

            add_filter('lisence_success_info_preorder', function ($txt) {
                $mesg = '<p style="color:green;font-size: 15px;margin: 0;"><span class="dashicons dashicons-yes-alt"></span> Congratulations! The Preorders for WooCommerce plugin '.$this->responseObj->msg.'</p>';

                $licRm = array( 'preorder-lic-rm' => '1' );

                return $mesg.'<a href="'.esc_url(add_query_arg($licRm)).'" class=" button">Deactivate License key</a>';
            });
           
            add_filter('lisence_style_preoder_field', function ($style) {
                return 'border:2px solid green;';
            });
           


        //$this->licenselMessage=$this->mess;
        //***Write you plugin's code here***
        } else {
            // $this->showMessage
            add_action('elite_licenser_hook', function () {
                wp_enqueue_script('ps-widget', 'https://app.productstash.io/js/productstash-embed.js', ['jquery'], null, true);
                wp_add_inline_script(
                    'ps-widget',
                    'var ps_config = {
                        productId : "616fecbd-67ec-494d-92d2-81f8fd87e77c"
                    }'
                );
            });

            if (!empty(get_option("wc_preorders_license_key")) && empty($this->showMessage) && empty($this->responseObj)) {
                add_filter('lisence_key_desc', function ($txt) {
                    return '<span style="color:red;">'.$this->licenseMessage.'</span>';
                });
            }
            add_filter('lisence_style_preoder_field', function ($style) {
                return 'border:2px solid red;';
            });
           
            
            add_action('admin_notices', [$this,'preorder_inactive_admin_notice']);
        }
    }
  
    public function preorder_inactive_admin_notice()
    {
        ?>
        <div class="notice notice-error preorder-notice">
        <p style="font-size:17px"><span style="color:#f56e28" class="dashicons dashicons-warning"></span>  Preorders for WooCommerce</p>
        <p style="font-size:15px"><?php  echo "Please <a href=".get_admin_url(null, 'admin.php?page=wc-settings&tab=settings_tab_preorders').">Register</a> your license key to get automatic compatibility upgrades, support. "; ?> </p>
        
        </div>
       <?php
    }
    public function action_activate_license()
    {
        update_option('_site_transient_update_plugins', '');
    }
}
