<?php

namespace Woocommerce_Preorders;

class Tabs
{
    public function __construct()
    {
        // Variations tab
        add_action('woocommerce_product_after_variable_attributes', [$this, 'customVariationsFields'], 10, 3); // After all Variation fields

        // Inventory tab
        add_action('woocommerce_product_options_stock_status', [$this, 'customSimpleFields']);

        add_action('woocommerce_save_product_variation', [$this, 'customVariationsFieldsSave'], 10, 2);
        add_action('woocommerce_process_product_meta', [$this, 'customSimpleFieldsSave'], 10, 2);
    }

    /*
     * Add our Custom Fields to variable products
     */
    public function customVariationsFields($loop, $variation_data, $variation)
    {
        echo '<div class="options_group form-row form-row-full">';
        woocommerce_wp_checkbox(
            [
                'id' => '_is_pre_order_' . $variation->ID,
                'label' => __('Pre-order Product', 'preorders-for-woocommerce-pro'),
                'description' => __(' Check this if you want to offer this product as pre-order', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta($variation->ID, '_is_pre_order', true)
            ]
        );

        woocommerce_wp_text_input(
            [
                'id' => '_pre_order_date_' . $variation->ID,
                'label' => __('Pre-order Date', 'preorders-for-woocommerce-pro'),
                'placeholder' => date('Y-m-d h:i:s'),
                'class' => 'datepicker',
                'desc_tip' => true,
                'description' => __('Choose when the product will be available.', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta($variation->ID, '_pre_order_date', true)
            ]
        );
        woocommerce_wp_select(
            [
                'id' => '_pre_order_stock_status' . $variation->ID,
                'label' => __('Preorder Stock Status', 'preorders-for-woocommerce-pro'),
                'default' => 'global',
                'options' =>array(
                    'global'     => __('Global Preorder Stock Status', 'preorders-for-woocommerce-pro'),
                    'instock' => __('In Stock', 'preorders-for-woocommerce-pro'),
                    'outofstock' => __('Out of Stock', 'preorders-for-woocommerce-pro'),
                ),
                'desc_tip'    => true,
                'description' => __('Once the preorder is finished on it\'s date cycle, the stock status will be automatically change to selected status.', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta($variation->ID, '_pre_order_stock_status', true)
            ]
        );


        echo '</div>';
    }

    /*
     * Save our variable product fields
     */
    public function customVariationsFieldsSave($post_id)
    {
        // $variation_id = $_POST['variable_post_id'][array_keys($_POST['variable_post_id'])[0]];
        $product = wc_get_product($post_id);

        $is_pre_order_variation = isset($_POST['_is_pre_order_' . $post_id]) ? 'yes' : 'no';
        $preorderStockStatus = sanitize_text_field($_POST['_pre_order_stock_status'. $post_id]);
        $product->update_meta_data('_is_pre_order', $is_pre_order_variation);
        $product->update_meta_data('_pre_order_stock_status', $preorderStockStatus);

        if ($is_pre_order_variation == 'yes') {
            $pre_order_date_value = esc_html($_POST['_pre_order_date_' . $post_id]);
            $product->update_meta_data('_pre_order_date', esc_attr($pre_order_date_value));
        }

        $product->save();
    }

    public function customSimpleFields()
    {
        echo '<div class="options_group form-row form-row-full hide_if_variable">';
        woocommerce_wp_checkbox(
            [
                'id' => '_exclude_pre_order',
                'label' => __('Exclude Pre-order', 'preorders-for-woocommerce-pro'),
                'description' => __('Check this if you want to exclude all category-wide rules for this product', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta(get_the_ID(), '_exclude_pre_order', true),
            ]
        );

        woocommerce_wp_checkbox(
            [
                'id' => '_is_pre_order',
                'label' => __('Pre-order Product', 'preorders-for-woocommerce-pro'),
                'description' => __(' Check this if you want to offer this product as pre-order', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta(get_the_ID(), '_is_pre_order', true),
            ]
        );

        woocommerce_wp_text_input(
            array(
            'id'          => '_pre_order_date',
            'label'       => __('Pre-order Date', 'preorders-for-woocommerce-pro'),
            'placeholder' => date('Y-m-d h:i:s'),
            'class'       => 'datepicker',
            'desc_tip'    => true,
            'description' => __("Choose when the product will be available.", "preorders"),
            'value' => get_post_meta(get_the_ID(), '_pre_order_date', true)
            )
        );
        woocommerce_wp_select(
            [
                'id' => '_pre_order_stock_status',
                'label' => __('Preorder Stock Status', 'preorders-for-woocommerce-pro'),
                'default' => 'global',
                'options' =>array(
                    'global'     => __('Global Preorder Stock Status', 'preorders-for-woocommerce-pro'),
                    'instock' => __('In Stock', 'preorders-for-woocommerce-pro'),
                    'outofstock' => __('Out of Stock', 'preorders-for-woocommerce-pro'),
                ),
                'desc_tip'    => true,
                'description' => __('Once the preorder is finished on it\'s date cycle, the stock status will be automatically change to selected status.', 'preorders-for-woocommerce-pro'),
                'value' => get_post_meta(get_the_ID(), '_pre_order_stock_status', true)
            ]
        );


        echo '</div>';
    }

    public function customSimpleFieldsSave($post_id)
    {
        $product = wc_get_product($post_id);
        $is_pre_order= isset($_POST['_is_pre_order']) ? 'yes' : 'no';
        $exclude_pre_order = isset($_POST['_exclude_pre_order']) ? 'yes' : 'no';
        $preorderStockStatus = sanitize_text_field($_POST['_pre_order_stock_status']);
        $product->update_meta_data('_is_pre_order', esc_attr($is_pre_order));
        $product->update_meta_data('_exclude_pre_order', esc_attr($exclude_pre_order));
        $product->update_meta_data('_pre_order_stock_status', $preorderStockStatus);

        if ($is_pre_order == 'yes') {
            $pre_order_date_value = esc_html($_POST['_pre_order_date']);
            $product->update_meta_data('_pre_order_date', esc_attr($pre_order_date_value));
        } else {
            $product->update_meta_data('_pre_order_date', '');
        }

        $product->save();
    }
}
