<?php

namespace Woocommerce_Preorders;

class Shop
{
    public function __construct()
    {
        add_filter('woocommerce_product_add_to_cart_text', [$this,'changeButtonText'], 10, 1);
        add_filter('woocommerce_product_single_add_to_cart_text', [$this,'changeButtonText'], 10, 1);
        add_filter('woocommerce_available_variation', [$this,'changeButtonTextForVariableProducts'], 10, 3);
        add_action('woocommerce_before_add_to_cart_form', [$this,'beforeAddToCartBtn'], 10);
        add_action('woocommerce_after_shop_loop_item', [$this,'afterShopLoopItem'], 10);
    }

    public function pregCountdown($string)
    {
        $patterns = array();
        $patterns[0] = '/%d/';
        $patterns[1] = '/%h/';
        $patterns[2] = '/%i/';
        $patterns[3] = '/%s/';

        $replacements = array();
        $replacements[0] = '(days)';
        $replacements[1] = '(hours)';
        $replacements[2] = '(minutes)';
        $replacements[3] = '(seconds)';

        return preg_replace($patterns, $replacements, $string);
    }
    /**
     * replace the Available date Text field
     *
     * @param [str] $string
     * @return void
     */
    public static function replaceDateTxt($string, $timeFormat, $humanTime, $countdown)
    {
        $patterns = array();
        $patterns[0] = '/%1$s/';
        $patterns[1] = '/%2$s/';
        $patterns[2] = '/%3$s/';
        $patterns[3] = '/{date_format}/';
        $patterns[4] = '/{human_readable}/';
        $patterns[3] = '/{countdown}/';

        $replacements = array();
        $replacements[0] = $timeFormat;
        $replacements[1] = $humanTime;
        $replacements[2] = $countdown;
        $replacements[3] = $timeFormat;
        $replacements[4] = $humanTime;
        $replacements[5] = $countdown;

        $find = array("%1\$s","{date_format}","%2\$s","{human_readable}","%3\$s","{countdown}");
        $replace = array($timeFormat,$timeFormat,$humanTime,$humanTime,$countdown,$countdown);

        return str_replace($find, $replace, $string);
    }

    public function afterShopLoopItem()
    {
        global $product;
        if ($product !== null && 'yes' == get_option('wc_preorders_avaiable_date_loop')) {
            if ('yes' == get_post_meta($product->get_id(), '_is_pre_order', true) && strtotime(get_post_meta($product->get_id(), '_pre_order_date', true)) > time()) {
                $timeFormat = date_i18n(get_option('date_format'), strtotime(get_post_meta($product->get_id(), '_pre_order_date', true))) ;

                $humanTime = human_time_diff(time(), strtotime(get_post_meta($product->get_id(), '_pre_order_date', true))) ;

                $countdownFormat = get_option('wc_preorders_countdown_format', '(days) p_days, (hours) p_hours, (minutes) p_minutes');

                $countdown = '<div class="countdown simple-bar" data-Date='.get_post_meta($product->get_id(), '_pre_order_date', true).' data-endText="">'.$this->pregCountdown($countdownFormat).'</div>';

                $text =  '<span class="preoder-span-block">'.self::replaceDateTxt(get_option('wc_preorders_avaiable_date_text'), $timeFormat, $humanTime, $countdown) .'<span>';

                echo apply_filters('preorder_avaiable_date_text_loop', $text);
            }
        }
    }

    public function beforeAddToCartBtn()
    {
        global $product;
        if ($product !== null && 'yes' == get_option('wc_preorders_avaiable_date_single_product')) {
            if ('yes' == get_post_meta($product->get_id(), '_is_pre_order', true) && strtotime(get_post_meta($product->get_id(), '_pre_order_date', true)) > time()) {
                $timeFormat = date_i18n(get_option('date_format'), strtotime(get_post_meta($product->get_id(), '_pre_order_date', true))) ;

                $humanTime = human_time_diff(time(), strtotime(get_post_meta($product->get_id(), '_pre_order_date', true)));

                $countdownFormat = get_option('wc_preorders_countdown_format', '(days) p_days, (hours) p_hours, (minutes) p_minutes');

                $countdown = '<div class="countdown simple-bar" data-Date='.get_post_meta($product->get_id(), '_pre_order_date', true).' data-endText="">'.$this->pregCountdown($countdownFormat).'</div>';
                $text =  self::replaceDateTxt(get_option('wc_preorders_avaiable_date_text'), $timeFormat, $humanTime, apply_filters('preorder_avaiable_date_countdown', $countdown)) ;
                
                echo apply_filters('preorder_avaiable_date_text', $text);
            }
        }
    }
    public function changeButtonTextForVariableProducts($data, $product, $variation)
    {
        if (get_post_meta($variation->get_id(), '_is_pre_order', true) == 'yes') {
            $data['is_pre_order'] = true;
            $data['preorder_date_time_format'] = date_i18n(get_option('date_format'), strtotime(get_post_meta($variation->get_id(), '_pre_order_date', true))) ;

            $data['preorder_date_human_time'] = human_time_diff(time(), strtotime(get_post_meta($variation->get_id(), '_pre_order_date', true))) ;
        }
        return $data;
    }
        


    public function changeButtonText($text)
    {
        global $post, $product;

        if ($product !== null) {
            if ('yes' == get_post_meta($post->ID, '_is_pre_order', true) && strtotime(get_post_meta($post->ID, '_pre_order_date', true)) > time()) {
                return get_option('wc_preorders_button_text');
            }
        }
        

        return $text;
    }
}
