<?php
namespace Woocommerce_Preorders;

class Settings
{
    public function __construct()
    {
        add_filter('woocommerce_settings_tabs_array', [$this, 'addSettingsTab'], 50);
        add_action('woocommerce_settings_tabs_settings_tab_preorders', [$this, 'settingsTab']);
        add_action('woocommerce_update_options_settings_tab_preorders', [$this, 'updateSettings']);
        add_filter("plugin_action_links_".WCPO_PLUGIN_BASE, [$this, 'addSettingsLink']);
        add_filter("plugin_row_meta", [$this, 'pluginMetaLinks'], 20, 2);
    }

    /**
     * Add links to plugin's description in plugins table
     *
     * @param array  $links  Initial list of links.
     * @param string $file   Basename of current plugin.
     *
     * @return array
     */
    public function pluginMetaLinks($links, $file)
    {
        if ($file !== WCPO_PLUGIN_BASE) {
            return $links;
        }
        $support_link = '<a style="color:red;" target="_blank" href="https://brightplugins.com/support/">' . __('Support', 'preorders-for-woocommerce-pro') . '</a>';
        
        $links[] = $support_link;
        
        return $links;
    } // plugin_meta_links

    public function addSettingsLink($links)
    {
        $row_meta = array(
            'settings' => '<a href="'.get_admin_url(null, 'admin.php?page=wc-settings&tab=settings_tab_preorders').'">' . __('Configure', 'preorders-for-woocommerce-pro') . '</a>',
        );
        
        return  array_merge($links, $row_meta);
    }

    public function addSettingsTab($settings_tabs)
    {
        $settings_tabs['settings_tab_preorders'] = __('Preorders', 'preorders-for-woocommerce-pro');

        return $settings_tabs;
    }

    public function settingsTab()
    {
        woocommerce_admin_fields($this->getSettings());
    }

    public function updateSettings()
    {
        woocommerce_update_options($this->getSettings());
        wp_safe_redirect(admin_url('admin.php?page=wc-settings&tab=settings_tab_preorders'));
    }

    public function getSettings()
    {
        update_option('wc_preorders_is_pro', 'yes');
        $licenseStyle = apply_filters('lisence_style_preoder_field', '');
        
        do_action('elite_licenser_hook');

        $settings = [
                'license_title' => [
                    'name' => __('License', 'preorders-for-woocommerce-pro'),
                    'type' => 'title',
                    'desc' => apply_filters('lisence_success_info_preorder', ''),
                    'id' => 'wc_settings_tab_preorders_license_title',
                ],
                'license_email' => [
                    'name' => __('License Email Address', 'preorders-for-woocommerce-pro'),
                    'type' => 'email',
                    'std' => '',
                    'css' => $licenseStyle,
                    'default' => '',
                    'desc' => __('The e-mail address you used for purchasing your license', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_license_email',
                ],
                'license_key' => [
                    'name' => __('License Key', 'preorders-for-woocommerce-pro'),
                    'type' => 'text',
                    'std' => '',
                    'css' => $licenseStyle,
                    'default' => '',
                    'desc' => __(apply_filters('lisence_key_desc', 'The license key is used for access to automatic upgrades and support.'), 'preordes'),
                    'id' => 'wc_preorders_license_key',
                ],
                'license_end' => [
                    'type' => 'sectionend',
                    'id' => 'wc_settings_tab_preorders_license_title',
                ],
                'section_title' => [
                    'name' => __('General Settings', 'preorders-for-woocommerce-pro'),
                    'type' => 'title',
                    'desc' => '',
                    'id' => 'wc_settings_tab_preorders_section_title',
                ],
                'preorders_mode' => [
                    'name' => __('Preorder Modes', 'preorders-for-woocommerce-pro'),
                    'type' => 'select',
                    'class'    => 'wc-enhanced-select',
                    'css'      => 'min-width: 350px;',
                    'options' => [
                        'whole' => __('Treat the entire order as preordered', 'preorders-for-woocommerce-pro'),
                        'partial' => __('Generate a separate order with all preordered products', 'preorders-for-woocommerce-pro'),
                        'individual' => __('Generate a separate order for each preordered products', 'preorders-for-woocommerce-pro'),
                        'either' => __('Order only preorder products or available ones', 'preorders-for-woocommerce-pro'),
                    ],
                    'id' => 'wc_preorders_mode',
                ],
                'after_completed' => [
                    'name' => __('Preorder Transition Status', 'preorders-for-woocommerce-pro'),
                    'type' => 'select',
                    'class'    => 'wc-enhanced-select',
                    'desc' =>  __('Choose which status should the order be set after the preorder date passed', 'preorders-for-woocommerce-pro'),
                    'options' => wc_get_order_statuses(),
                    'default' => 'wc-processing',
                    'id' => 'wc_preorders_after_completed',
                ],
                'preorders_date_cycle' => [
                    'name' => __('Product Date Cycle', 'preorders-for-woocommerce-pro'),
                    'type' => 'select',
                    'class'    => 'wc-enhanced-select',
                    'css'      => 'min-width: 230px;',
                    'default' => 'in-stock',
                    'options' => [
                        'instock' => __('In Stock', 'preorders-for-woocommerce-pro'),
                        'outofstock' => __('Out of Stock', 'preorders-for-woocommerce-pro'),
                       
                    ],
                    'desc' =>  __('Once the preorder is finished on it\'s date cycle, the stock status will be automatically change to selected status', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_product_date_cycle',
                ],
                'prevent_shipping_cost' => [
                    'name' => __('Unify Shipping Costs', 'preorders-for-woocommerce-pro'),
                    'type' => 'checkbox',
                    'std' => 'no',
                    'default' => 'no',
                    'desc' => __('If you have more than 1 order is generated, let the customer pay only 1 shipment for all orders.<br> This option will use the shipment method as if it were only 1 order.', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_prevent_shipping_cost',
                ],
                'force_date' => [
                    'name' => __('Choose shipping date', 'preorders-for-woocommerce-pro'),
                    'type' => 'checkbox',
                    'std' => 'yes',
                    'default' => 'yes',
                    'desc' => __('Allow customers to choose a desired shipping date (after all products are available).', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_always_choose_date',
                ],
                'change_button' => [
                    'name' => __('Change button title for preorder products', 'preorders-for-woocommerce-pro'),
                    'type' => 'checkbox',
                    'std' => 'yes',
                    'default' => 'yes',
                    'id' => 'wc_preorders_change_button',
                ],
                /*'multiply_shipping' => [
                'name' => __('Multiply the shipping costs by the amount of orders', 'preorders-for-woocommerce-pro'),
                'type' => 'checkbox',
                'std'  => 'yes',
                'default' => 'yes',
                'desc' => __('This means, if you are going to generate 2 orders (one for the pre-ordered products and one for the normal ones, then the customer will have to pay for both shippings).', 'preorders-for-woocommerce-pro'),
                'id' => 'wc_preorders_multiply_shipping'
            ],*/
                'change_button_text' => [
                    'name' => __('Add Button Title', 'preorders-for-woocommerce-pro'),
                    'type' => 'text',
                    'std' => 'Preorder Now!',
                    'default' => 'Preorder Now!',
                    'id' => 'wc_preorders_button_text',
                ],
               
                'enable_avaiable_date_1' => [
                    'name' => __('Choose where to display the Available Date', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_avaiable_date_single_product',
                    'default'         => 'yes',
                    'type'            => 'checkbox',
                    'checkboxgroup'   => 'start',
                    'desc'            => __('Single Product Page', 'preorders-for-woocommerce-pro'),
                ],
                'enable_avaiable_date_2' =>[
                    'id' => 'wc_preorders_avaiable_date_loop',
                    'default'         => 'no',
                    'checkboxgroup'   => '',
                    'type'            => 'checkbox',
                    'autoload' => true,
                    'desc'            => __('Catalog Page(s)', 'preorders-for-woocommerce-pro'),
                ],
                'enable_avaiable_date_3' =>[
                    'id' => 'wc_preorders_avaiable_date_cart_item',
                    'default'         => 'no',
                    'type'            => 'checkbox',
                    'checkboxgroup'   => '',
                    'autoload' => true,
                    'desc'            => __('Cart Page', 'preorders-for-woocommerce-pro'),
                ],
                'enable_avaiable_date_4' =>[
                    'id' => 'wc_preorders_avaiable_date_checkout_item',
                    'default'         => 'no',
                    'type'            => 'checkbox',
                    'checkboxgroup'   => 'end',
                    'autoload' => true,
                    'desc'            => __('Checkout Page', 'preorders-for-woocommerce-pro'),
                ],
                'change_cart_notice_text' => [
                    'name' => __('Preorder Cart Notice', 'preorders-for-woocommerce-pro'),
                    'type' => 'text',
                    'default' => 'Note: this item will be available for shipping in {days_left} days',
                    'desc' => '
                    Text will be shown below the preoder product on the cart page<br/>
                    <strong>Available vars:</strong><br/>
                    <code>{days_left}</code> = Count preorder date',
                    
                    'id' => 'wc_preorders_cart_product_text',
                ],
                'change_avaiable_date_text' => [
                    'name' => __('Available date Text', 'preorders-for-woocommerce-pro'),
                    'type' => 'text',
                    'default' => 'Available on %1$s',
                    'desc' => '
                    Choose how the available date should be displayed. You can use 3 different variables inside the text,<br/> to show either the normal date, the amount of weeks left, or a dynamic countdown. For more information please visit this <a href="https://brightplugins.com/docs/dynamic-vars/" target="_blank">docs page</a><br/>
                    <strong>Available vars:</strong><br/>
                    <code>{date_format}</code> = Default site date format ( January 15, 2020 ) <br> 
                    <code>{human_readable}</code> = 3 weeks  <br> 
                    <code>{countdown}</code> = Countdown Timer',
                    'id' => 'wc_preorders_avaiable_date_text',
                ],
                'change_countdown_format' => [
                    'name' => __('Countdown Format', 'preorders-for-woocommerce-pro'),
                    'type' => 'text',
                    'default' => '%d days, %h hours, %i minutes, %s seconds',
                    'desc' => '%d days, %h hours, %i minutes, %s seconds',
                    'id' => 'wc_preorders_countdown_format',
                ],
                'disable_payment' => [
                    'name' => __('Disable Payment Methods', 'preorders-for-woocommerce-pro'),
                    'type' => 'multiselect',
                    'class'    => 'wc-enhanced-select',
                    'css'      => 'min-width: 250px;',
                    'desc'     => __('Disable Payment gateway if cart has preorder product(s)', 'preorders-for-woocommerce-pro'),
                    'options' => bootstrap::paymentGatewayList(),
                    'id' => 'wc_preorders_disable_payment',
                ],
                'section_end' => [
                    'type' => 'sectionend',
                    'id' => 'wc_settings_tab_preorders_section_end',
                ],
                'section_title_notification' => [
                    'name' => __('Notifications', 'preorders-for-woocommerce-pro'),
                    'type' => 'title',
                    'desc' => '',
                    'id' => 'wc_settings_tab_preorders_section_notification_title',
                ],
                'preorder_alert' => [
                    'name' => __('Preorder Alert', 'preorders-for-woocommerce-pro'),
                    'type' => 'number',
                    'css' => 'max-width:70px;',
                    'default' => '0',
                    'desc'     => __('Amount of days in advance that admins will get an e-mail notification when a preorder will be available.<br/> Leave 0 if you want to leave this feature disabled', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorders_alert',
                ],
                'preoder_customer_notify' => [
                    'name' => __('Customer Notification', 'preorders-for-woocommerce-pro'),
                    'type' => 'checkbox',
                    'std' => 'yes',
                    'default' => 'yes',
                    'desc'     => __('when preorder date will arrived customers will get email notification with Order details', 'preorders-for-woocommerce-pro'),
                    'id' => 'wc_preorder_customer_notification',
                ],
                'section_end_notification' => [
                    'type' => 'sectionend',
                    'id' => 'wc_settings_tab_preorders_section_notification_end',
                ],
            ];
        

        return apply_filters('wc_settings_tab_preorders_settings', $settings);
    }
}
