<?php

namespace Woocommerce_Preorders;

class ProductTaxonomy
{
    public function __construct()
    {
        add_action('product_cat_add_form_fields', [$this,'addTermFields']);
        add_action('product_cat_edit_form_fields', [$this,'editTermFields'], 10, 2);
        
        add_action('created_product_cat', [$this,'saveTermFields']);
        add_action('edited_product_cat', [$this,'saveTermFields']);

        add_action('edited_product_cat', [$this,'TaxomonyPreorder'], 90, 2);
        add_action('created_product_cat', [$this,'TaxomonyPreorder'], 90, 2);
        add_action('save_post', [$this,'globalPreorderValueOnSavePost'], 20, 2);
    }
    /**
     * Add Preoder options into product category
     *
     * @param [type] $taxonomy
     * @return void
     */
    public function addTermFields($taxonomy)
    {
        $html = '<div class="form-field">
        <p style="color:#000;">'.__('Preorder', 'preorders-for-woocommerce-pro').'</p>
        <div style="display: flex;"><input type="checkbox" style="margin-top: 3px;" name="preorder-checkbox-cat" id="preorder-checkbox-cat" />
        <label for="preorder-checkbox-cat">'.__('Check this if you want to offer this category as pre-order', 'preorders-for-woocommerce-pro').'</label>
        </div>
        </div>';
        $html .= '<div class="form-field">
        <label for="preorder-date-cat">'.__('Preorder Date', 'preorders-for-woocommerce-pro').'</label>
        <input type="text" class="datepicker" name="preorder-date-cat" id="preorder-date-cat" />
        <p class="description">'.__('Choose when the product will be available.', 'preorders-for-woocommerce-pro').'</p>
        </div>';

        echo $html;
    }
    
    /**
     * Add preoder fields into edit product category page
     *
     * @param [type] $term
     * @param [type] $taxonomy
     * @return void
     */
    public function editTermFields($term, $taxonomy)
    {
        $checkboxPreorderValue = get_term_meta($term->term_id, 'preorder-checkbox-cat', true);
        $datePreorderValue = get_term_meta($term->term_id, 'preorder-date-cat', true);
        
        $html = '<tr class="form-field">
        <th>
           <label for="preorder-checkbox-cat">'.__('Preorder', 'preorders-for-woocommerce-pro').'</label>
        </th>
        <td>
        <div style="display: flex;">
         
            <input style="margin-top: 7px;" type="checkbox" style="margin-top: 3px;" name="preorder-checkbox-cat" id="preorder-checkbox-cat"  '.($checkboxPreorderValue ? ' checked="checked"' : null).' />
            
            <p class="description">'.__('Check this if you want to offer this category as pre-order', 'preorders-for-woocommerce-pro').'.</p>
        </div>
        </td>
        </tr>';
        $html .= '<tr class="form-field">
        <th>
           <label for="preorder-date-cat">'.__('Preorder Date', 'preorders-for-woocommerce-pro').'</label>
        </th>
        <td>
       
            <input type="text" class="datepicker" name="preorder-date-cat" id="preorder-date-cat" value="' . esc_attr($datePreorderValue) .'"/>
            <p class="description">'.__('Choose when the product will be available.', 'preorders-for-woocommerce-pro').'</p>
   
        </td>
        </tr>
        
        ';
        echo $html;
    }
    /**
     * Save preorder fields data
     *
     * @param [int] $term_id
     * @return void
     */
    public function saveTermFields($term_id)
    {
        update_term_meta(
            $term_id,
            'preorder-checkbox-cat',
            sanitize_text_field($_POST['preorder-checkbox-cat'])
        );
        update_term_meta(
            $term_id,
            'preorder-date-cat',
            sanitize_text_field($_POST['preorder-date-cat'])
        );
    }
    /**
     * Run the function if taxonomy has value into
     * the preorder fields
     *
     * Basically it will override the default product preorder
     * meta fields with taxomony preorder value
     *
     * @return void
     */
    public function TaxomonyPreorder($term_id)
    {
        //todo :add background processing
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'product_cat',
                    'terms' => $term_id,
                    'operator' => 'IN',
                )
            )
        );
        $bpProducts = new \WP_Query($args);

        foreach ($bpProducts->posts as $pId) {
            $taxonomyPreorder = (get_term_meta($term_id, 'preorder-checkbox-cat', true)) ? 'yes' : 'no';
            $taxonomyPreorderDate = get_term_meta($term_id, 'preorder-date-cat', true);

           
            $bpProductObj = wc_get_product($pId->ID);

            if ($bpProductObj->is_type('simple') && get_post_meta($pId->ID, '_exclude_pre_order', true) != 'yes') {
                update_post_meta($pId->ID, '_is_pre_order', $taxonomyPreorder);
                update_post_meta($pId->ID, '_pre_order_date', $taxonomyPreorderDate);
            }
        }
    }
    /**
     * set preorder value on new product create
     *
     * @param [type] $post_id
     * @param [type] $post
     * @return void
     */
    public function globalPreorderValueOnSavePost($post_id, $post)
    {
        

        // Only set for post_type = product!
        if ('product' !== $post->post_type) {
            return;
        }

        $bpProductObj = wc_get_product($post_id);
        $bpTaxonomy = get_the_terms($post_id, 'product_cat');
     
        $taxonomyPreorder = (get_term_meta($bpTaxonomy[0]->term_id, 'preorder-checkbox-cat', true)) ? 'yes' : 'no';
        $taxonomyPreorderDate = get_term_meta($bpTaxonomy[0]->term_id, 'preorder-date-cat', true);

        if ($bpProductObj->is_type('simple') && get_post_meta($post_id, '_exclude_pre_order', true) != 'yes' && $taxonomyPreorder == 'yes') {
            update_post_meta($post_id, '_is_pre_order', $taxonomyPreorder);
            update_post_meta($post_id, '_pre_order_date', $taxonomyPreorderDate);
        }
    }
}
