<?php

namespace Woocommerce_Preorders;

class Product
{
    private $product;
    private $isPreOrder = false;
    private $preOrderDate;
    private $stockStatus;

    public function __construct($productId, $variableId =0)
    {
        $this->product = wc_get_product($productId);
        if ('yes' === get_post_meta($this->product->get_id(), '_is_pre_order', true) && new \DateTime(get_post_meta($this->product->get_id(), '_pre_order_date', true)) > new \DateTime()) {
            $this->isPreOrder = true;
            $this->preOrderDate = get_post_meta($this->product->get_id(), '_preorder_date', true);
        } elseif ('yes' === get_post_meta($variableId, '_is_pre_order', true) && new \DateTime(get_post_meta($variableId, '_pre_order_date', true)) > new \DateTime()) {
            $this->isPreOrder = true;
            $this->preOrderDate = get_post_meta($variableId, '_preorder_date', true);
        }

        // set new stock status
        if ('yes' === get_post_meta($this->product->get_id(), '_is_pre_order', true) && new \DateTime(get_post_meta($this->product->get_id(), '_pre_order_date', true)) < new \DateTime()) {
            $this->stockStatus = (empty(get_post_meta($productId, '_pre_order_stock_status', true)) || get_post_meta($productId, '_pre_order_stock_status', true) == 'global') ? get_option('wc_preorders_product_date_cycle') : get_post_meta($productId, '_pre_order_stock_status', true);
            update_post_meta($productId, '_stock_status', $this->stockStatus); // update stock status
        } elseif ('yes' === get_post_meta($variableId, '_is_pre_order', true) && new \DateTime(get_post_meta($variableId, '_pre_order_date', true)) < new \DateTime()) {
            $this->stockStatus = (empty(get_post_meta($productId, '_pre_order_stock_status', true)) || get_post_meta($variableId, '_pre_order_stock_status', true) == 'global') ? get_option('wc_preorders_product_date_cycle') : get_post_meta($variableId, '_pre_order_stock_status', true);
            update_post_meta($variableId, '_stock_status', $this->stockStatus);  // update stock status
        }
    }

    public function getShippingDate()
    {
        if (!$this->isPreOrder) {
            return __('Already shipped', 'preorders-for-woocommerce-pro');
        }
        $shippingDate = strtotime($this->preOrderDate);
        $now = strtotime(time());
        $diff = round(($shippingDate - $now) / (60 * 60 * 24));

        if ($diff > 0) {
            echo sprintf(__('Available in %s days', 'preorders-for-woocommerce-pro'), $diff->d);
        } elseif ($diff == 0) {
            return __('Available today', 'preorders-for-woocommerce-pro');
        } else {
            return __('Already shipped', 'preorders-for-woocommerce-pro');
        }
    }

    public function isPreOrder()
    {
        return $this->isPreOrder;
    }
}
