<?php

namespace Woocommerce_Preorders;

class Packages
{
    public function __construct()
    {
        if (apply_filters('shop_have_free_shipping_based_on_amount', false)) {
            add_filter('woocommerce_package_rates', array( $this , 'remove_free_shpping_method' ), 10, 2);
        }

        add_filter('woocommerce_cart_shipping_packages', array( &$this, 'generateVendors'), 100, 1);
    }

    public function remove_free_shpping_method($rates, $package)
    {
        $shipping_method_id = 'free_shipping'; // sets free shipping as the deactivated method
        $remove_free_method = false;
    
        $total = WC()->cart->get_displayed_subtotal();
        if ($total >= apply_filters('set_free_shipping_min_amount', 100) && apply_filters('set_free_shipping_preorder', false)) {
            $remove_free_method = true;
        }
        if ($remove_free_method) {
            $shipping_methods_disable = array();
            foreach ($rates as $rate_id => $rate) {
                if ($shipping_method_id !== $rate->method_id) {
                    $shipping_methods_disable[$rate_id] = $rate;
                }
            }
        }

        return !empty($shipping_methods_disable) ? $shipping_methods_disable : $rates;
    }

    public function generateVendors($packages)
    {
        if ('yes' == get_option('wc_preorders_prevent_shipping_cost')) {
            return $packages;
        }

        /*
         * Needs refactor
         */
        if (get_option('wc_preorders_mode')  == 'individual') {
            $packages = [];
            $physicalProduts = [];
            $regular_items = [];
            $vendors = [];
            //$packages['ship_via'] = array( 'flat_rate' );
            $i=1;
            foreach (WC()->cart->get_cart() as $item) {
                $productId = isset($item['variation_id']) && 0 !== $item['variation_id'] ? $item['variation_id'] : $item['product_id'];
                $p = new Product($productId);
                $wproduct = wc_get_product($productId);

                if ($p->isPreOrder() && $wproduct->is_downloadable() === false) {
                    $vendors[$i][] = $item;
                    $i++;
                } elseif ($p->isPreOrder() == false && $wproduct->is_downloadable() === false) {
                    $regular_items[] = $item;
                }
            }
            

            foreach ($vendors as $key => $vendor_items) {
                $packages[] = array(
                    
                    'contents' => $vendor_items,
                    'contents_cost' => array_sum(wp_list_pluck($vendor_items, 'line_total')),
                    'applied_coupons' => WC()->cart->applied_coupons,
                    'destination' => array(
                        'country' => WC()->customer->get_shipping_country(),
                        'state' => WC()->customer->get_shipping_state(),
                        'postcode' => WC()->customer->get_shipping_postcode(),
                        'city' => WC()->customer->get_shipping_city(),
                        'address' => WC()->customer->get_shipping_address(),
                        'address_2' => WC()->customer->get_shipping_address_2()
                    )
                );
            }
            if ($regular_items) {
                $packages[] = array(
                        'ship_via' => (array_sum(wp_list_pluck($regular_items, 'line_total')) >= apply_filters('set_free_shipping_min_amount', 100) && apply_filters('shop_have_free_shipping_based_on_amount', false)) ? array('free_shipping') : null ,
                        'contents' => $regular_items,
                        'contents_cost' => array_sum(wp_list_pluck($regular_items, 'line_total')),
                        'applied_coupons' => WC()->cart->applied_coupons,
                        'destination' => array(
                            'country' => WC()->customer->get_shipping_country(),
                            'state' => WC()->customer->get_shipping_state(),
                            'postcode' => WC()->customer->get_shipping_postcode(),
                            'city' => WC()->customer->get_shipping_city(),
                            'address' => WC()->customer->get_shipping_address(),
                            'address_2' => WC()->customer->get_shipping_address_2()
                        )
                    );
            }
        } elseif (get_option('wc_preorders_mode') == 'partial') {
            $packages = array();
            $preoders_items = array();
            $regular_items = array();
            $total = WC()->cart->get_displayed_subtotal();
            $physicalProduts = [];

            foreach (WC()->cart->get_cart() as $item) {
                $productId = isset($item['variation_id']) && 0 !== $item['variation_id'] ? $item['variation_id'] : $item['product_id'];
                $p = new Product($productId);
                $wproduct = wc_get_product($productId);

                if ($p->isPreOrder() && $wproduct->is_downloadable() === false) {
                    $preoders_items[] = $item;
                    $physicalProduts[] = $wproduct->is_downloadable();
                } elseif ($p->isPreOrder() == false && $wproduct->is_downloadable() === false) {
                    $regular_items[] = $item;
                }
            }
        
            if ($preoders_items && in_array(false, $physicalProduts)) {
                $packages[] = array(

                       
                        'ship_via' => (array_sum(wp_list_pluck($preoders_items, 'line_total')) >= apply_filters('set_free_shipping_min_amount', 100) && apply_filters('shop_have_free_shipping_based_on_amount', false)) ? array('free_shipping') : null ,
                        'contents' => $preoders_items,
                        'contents_cost' => array_sum(wp_list_pluck($preoders_items, 'line_total')),
                        'applied_coupons' => WC()->cart->applied_coupons,
                        'user'            => array(
                            'ID' => get_current_user_id(),
                        ),
                        'destination' => array(
                            'country' => WC()->customer->get_shipping_country(),
                            'state' => WC()->customer->get_shipping_state(),
                            'postcode' => WC()->customer->get_shipping_postcode(),
                            'city' => WC()->customer->get_shipping_city(),
                            'address' => WC()->customer->get_shipping_address(),
                            'address_2' => WC()->customer->get_shipping_address_2()
                        )
                    );
            }
            if ($regular_items) {
                $packages[] = array(
                        'ship_via' => (array_sum(wp_list_pluck($regular_items, 'line_total')) >= apply_filters('set_free_shipping_min_amount', 100) && apply_filters('shop_have_free_shipping_based_on_amount', false)) ? array('free_shipping') : null ,
                        'contents' => $regular_items,
                        'contents_cost' => array_sum(wp_list_pluck($regular_items, 'line_total')),
                        'applied_coupons' => WC()->cart->applied_coupons,
                        'user'            => array(
                            'ID' => get_current_user_id(),
                        ),
                        'destination' => array(
                            'country' => WC()->customer->get_shipping_country(),
                            'state' => WC()->customer->get_shipping_state(),
                            'postcode' => WC()->customer->get_shipping_postcode(),
                            'city' => WC()->customer->get_shipping_city(),
                            'address' => WC()->customer->get_shipping_address(),
                            'address_2' => WC()->customer->get_shipping_address_2()
                        )
                    );
            }
        }


                
        return $packages;
    }
}
