<?php

namespace Woocommerce_Preorders;

class Order
{
    public function __construct()
    {
        add_filter('manage_edit-shop_order_columns', [$this, 'preorderCustomColumn'], 20);
        add_action('manage_shop_order_posts_custom_column', [$this, 'preorderCustomColumnContent']);
        add_action('woocommerce_order_item_meta_end', [$this, 'saveCustomMetaAsOrderItemMeta'], 20, 2);
        add_action('add_meta_boxes', [$this, 'addMetaBoxPreOrderDate']);
        add_action('woocommerce_process_shop_order_meta', [$this, 'saveManualPreOrderFields'], 10, 1);
    }

    /**
     * Save cart item custom meta as order item meta data
     * and display it everywhere on orders and email notifications.
     *
     */
    public function saveCustomMetaAsOrderItemMeta($itemId, $item)
    {
        if ('yes' == get_post_meta($item->get_product_id(), '_is_pre_order', true) && strtotime(get_post_meta($item->get_product_id(), '_pre_order_date', true)) > time()) {
            $timeFormat = date_i18n(get_option('date_format'), strtotime(get_post_meta($item->get_product_id(), '_pre_order_date', true)));

            $humanTime = human_time_diff(time(), strtotime(get_post_meta($item->get_product_id(), '_pre_order_date', true)));

            $text =  Shop::replaceDateTxt(get_option('wc_preorders_avaiable_date_text'), $timeFormat, $humanTime, $timeFormat);

            echo '<br><small ' . apply_filters('preorder_cart_item_att', '') . '>' . apply_filters('preorder_avaiable_date_text', $text) . '</small>';
        }
    }
    public function preorderCustomColumn($columns)
    {
        $newColumns = [];
        foreach ($columns as $columnName => $columnInfo) {
            $newColumns[$columnName] = $columnInfo;
            if ('order_total' === $columnName) {
                $newColumns['order_preorder_date'] = __('Preorder Date', 'preorders-for-woocommerce-pro');
            }
        }

        return $newColumns;
    }

    public function getPreOrderDate($order)
    {
        if (get_post_meta($order->ID, '_preorder_date', true) == '') {
            return;
        }
        $shippingDate = strtotime(get_post_meta($order->ID, '_preorder_date', true));
        $now = time();
        $diff = round(($shippingDate - $now) / (60 * 60 * 24));
        if ($diff > 0) {
            return sprintf(__('Available in %s days', 'preorders-for-woocommerce-pro'), $diff);
        } elseif ($diff == 0) {
            return __('Available today', 'preorders-for-woocommerce-pro');
        } else {
            return __('Already shipped', 'preorders-for-woocommerce-pro');
        }
    }

    public function preorderCustomColumnContent($column)
    {
        if ('order_preorder_date' === $column) {
            global $post;
            echo $this->getPreOrderDate($post);
        }
    }


    public function addMetaBoxPreOrderDate()
    {
        add_meta_box('order_predate_field', __('Pre-order Date', 'preorders-for-woocommerce-pro'), [$this , 'addPreOrderDateField'], 'shop_order', 'side', 'core');
    }

    
    public function addPreOrderDateField()
    {
        global $post;
        
        $order = wc_get_order(get_the_ID($post));
        $meta_field_data = get_post_meta($order->get_id(), '_preorder_date', true) ? get_post_meta($order->get_id(), '_preorder_date', true) : '';
    
        woocommerce_wp_text_input(
            array(
                'id' => '_pre_order_date',
                'name'        => '_preorder_date',
                'label' => __('Pre-order Date', 'preorders-for-woocommerce-pro'),
                'placeholder' => date('Y-m-d h:i:s'),
                'class'       => 'datepicker',
                'desc_tip'    => true,
                'description' => __("Choose when the product will be available.", "preorders"),
                'value' => $meta_field_data
            )
        );
    }

    public function saveManualPreOrderFields($post_id)
    {
        update_post_meta($post_id, '_preorder_date', esc_attr($_POST['_preorder_date']));
    }
}
