<?php

namespace Woocommerce_Preorders;

class Notices
{
    public function __construct()
    {
        // if(get_option('woocommerce_preorders_show_individual_cart_notices') == 'yes')
        add_action('woocommerce_after_cart_item_name', [$this,'addPreorderNotice'], 10, 2);

        if (get_option('woocommerce_preorders_show_general_cart_notice') == 'yes') {
            add_action('woocommerce_before_cart', [$this, 'addPreorderNotices']);
        }
            

        if (get_option('wc_preorders_is_pro') == 'no') {
            add_action('admin_notices', [$this,'addBuyProNotice']);
        }
        
        add_action('admin_init', [$this,'noticeParamCheck'], 90);
        add_action('admin_notices', [$this,'pofwcAdminReview']);
        add_action('admin_notices', [$this,'newPluginNotification']);
    }
    public function newPluginNotification()
    {
        $dismissPram = array( 'bpwcavi-dismiss' => '1' );
  
        if (get_option('bpwcavi-dismiss')) {
            return;
        } ?>
        <div class="notice notice-success bp-new-alert woocomemrce-inner-bpwcavi">
        <div class="bp-logo bp-logo-1"><img src="<?php echo WCPO_PLUGIN_URL.'media/img/bp-logo.png'; ?>" alt="Bright Plugins logo"><span>30% OFF</span></div>
        <div class="exclusive-txt">Exclusive Deal on our new plugin: </div>
        <div class="wcavi-img-banner-1">
            <img width="100%" src="<?php echo WCPO_PLUGIN_URL.'media/img/Variation-Images-for-WooCommerce-600x383.png'; ?>" alt="Bright Plugins logo"> 
           
        </div>
        <a target="_blank" class="new-link-bp" href="https://brightplugins.com/additional-variation-images-for-woocommerce/" >Additional Variation Images for WooCommerce </a>
        <a style="float:right" href="<?php echo esc_url(add_query_arg($dismissPram)); ?>" class="dfwc-button-notice-dismiss button button-link"><?php _e('Hide Notification', 'wpgs'); ?></a>
    </div>
   
    <?php
    }
    public function addPreorderNotice($cartItem, $cartItemKey)
    {
        $product = $cartItem['data'];
        if (get_post_meta($product->get_id(), '_pre_order_date', true) !== null) {
            $availableFrom = new \DateTime(get_post_meta($product->get_id(), '_pre_order_date', true));
            $now = new \DateTime();

            $diff = $now->diff($availableFrom)->format('%a');

            if ($availableFrom > $now && $diff > 0) {
                $notice = '<br/><small class="preorder-cart-notice" style="color:red">'.get_option('wc_preorders_cart_product_text', 'Note: this item will be available for shipping in {days_left} days').'</small>';
                


                if (get_option('wc_preorders_avaiable_date_cart_item') == 'yes') {
                    echo apply_filters('preorder_avaiable_date_text_cart', str_replace('{days_left}', $diff, $notice), $diff);
                }
            }
        }
    }

    public function addPreorderNotices()
    {
        global $woocommerce;
        $actualCart = $woocommerce->cart->get_cart();

        $cart = new Cart();

        $cart->checkPreOrderProducts($actualCart);
        if (count($cart->getPreOrderProducts()) > 0) {
            wc_add_notice(__('Warning! you have selected certain products which are not available right now. You will have to choose a shipping date before you can place your order.', 'preorders-for-woocommerce-pro'), 'notice');
        }
    }

    public function addBuyProNotice()
    {
        echo '<div class="error notice"><p>'.__('<strong>Hey there!</strong><br>You are currently using a free version of our awesome plugin WooCommerce Preorders. If you want to activate all the functionalities, please <a target="_blank" href="https://brightplugins.com/woocommerc-preorder-plugin/">click here</a> to buy a license. We also offer awesome support and customizations!.', 'preorders-for-woocommerce-pro').'</p></div>';
    }
    /**
     * simple dismissable logic
     *
     * @return void
     */
    public function noticeParamCheck()
    {
        if (isset($_GET['pofwc-review-dismiss']) && $_GET['pofwc-review-dismiss'] == 1) {
            update_option('pofwc_plugin_review', 1);
        } elseif (isset($_GET['pofwc-review-later']) && $_GET['pofwc-review-later'] == 1) {
            set_transient('pofwc_review_later', 1, 2 * DAY_IN_SECONDS); // for 2 days
        }
        // wcavi dismiss
        
        if (isset($_GET['bpwcavi-dismiss']) && $_GET['bpwcavi-dismiss'] == 1) {
            update_option('bpwcavi-dismiss', 1);
        }
    }
    public function pofwcAdminReview()
    {
        $dismissParm = array( 'pofwc-review-dismiss' => '1' );
        $dismissLaterParm = array( 'pofwc-review-later' => '1' );

        $pofwcActicationTime = strtotime('+7 day', get_option('pofwc_plugin_activation'));

        if (get_option('pofwc_plugin_review') || get_transient('pofwc_review_later') ||time() < $pofwcActicationTime) {
            return;
        } ?>
        <div class="notice" style="padding: 12px 20px;border: none;">
            <p style="font-size:15px"><?php _e('Are you enjoying Preorders for WooCommerce? if so please do not forget to give us a 5-star review.', 'preorders-for-woocommerce-pro'); ?></p>
            <p class="dfwc-message-actions">
                <a style="margin-right:5px;" href="https://wordpress.org/support/plugin/pre-orders-for-woocommerce/reviews/?filter=5/#new-post" target="_blank" class="button button-primary button-primary"><?php _e('Give Feedback', 'preorders-for-woocommerce-pro'); ?></a>
                <a  style="margin-right:5px;" href="<?php echo esc_url(add_query_arg($dismissLaterParm)); ?>" class="dfwc-button-notice-dismiss button"><?php _e('Remind me later', 'preorders-for-woocommerce-pro'); ?></a>
                <a  style="margin-right:5px;" href="<?php echo esc_url(add_query_arg($dismissParm)); ?>" class="dfwc-button-notice-dismiss button"><?php _e('I already did', 'preorders-for-woocommerce-pro'); ?></a>
            </p>
        </div>
    <?php
    }
}
