<?php
namespace Woocommerce_Preorders;

class Coupons
{
    public function __construct()
    {
        add_filter('woocommerce_check_cart_items', [$this, 'checkPreorderCoupon'], 99);
        add_action('woocommerce_coupon_options_usage_restriction', [$this, 'addCouponFields'], 10);
        add_action('woocommerce_coupon_options_save', [$this, 'saveCouponTextFields'], 10, 2);
    }
    public function checkPreorderCoupon()
    {
        
        // check if cart have preoder products
        $PreorderProducts = [];
        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            $PreorderProducts[] =   get_post_meta($cart_item['data']->get_id(), '_is_pre_order', true);
        }
        $coupon_applieds = WC()->cart->get_applied_coupons();
        $hasPreoder = in_array('yes', $PreorderProducts);

        // Avoid checkout displaying an error notice
        if ($coupon_applieds) {
            $preorderCoupon = new \WC_Coupon($coupon_applieds[0]);

            if (!empty($preorderCoupon->get_meta('only_preorder')) && $hasPreoder == false) {
                wc_add_notice('The Coupon code only apply if you have preorder product(s) into cart', 'error');
                WC()->cart->remove_coupons();
            }
           
    
            // return false;
        }
    }
    /**
    * Add coupons fields
    *
    * @return void
    */
    public function addCouponFields()
    {
        woocommerce_wp_checkbox(
            array(
                'id'          => 'only_preorder',
                'label'       => __('Only Preorder', 'preorders-for-woocommerce-pro'),
                'description' =>  __('Check this box if this coupon should only work on preorder items', 'preorders-for-woocommerce-pro'),
                
            )
        );
    }

    /**
     * Save the custom field value from Admin coupon settings pages
     *
     * @param [type] $post_id
     * @param [type] $coupon
     * @return void
     */
    public function saveCouponTextFields($post_id, $coupon)
    {
        $coupon->update_meta_data('only_preorder', sanitize_text_field($_POST['only_preorder']));
        $coupon->save();
    }
}
