<?php

namespace Woocommerce_Preorders;

class Bootstrap
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'adminEnqueueStyles']);
        add_action('admin_enqueue_scripts', [$this, 'adminEnqueueScripts']);
        add_action('wp_enqueue_scripts', [$this, 'frontEnqueueStyles']);
        add_action('wp_enqueue_scripts', [$this, 'frontEnqueueScripts']);
        add_shortcode('preorder_products', [$this, 'preorderProducts']);

        $this->generatePreOrderStatus();

        // // add_action('woocommerce_thankyou', [$checkout, 'checkGeneratedOrderStatus']);
        $this->initializeCheckout();
        $this->initializeSync();
        $this->initializeTabs();
        $this->initializeNotices();
        $this->initializeSettings();
        $this->initializeShop();
        $this->initializeOrder();
        $this->initialProductTaxonomy();
        $this->initializeCoupons();
        $this->initializeUpdates();
        new Backend();
    }
    /**
     * Display preorder products via shortcode
     *
     * @param [type] $atts
     * @return void
     */
    public function preorderProducts($atts)
    {
        global $woocommerce_loop;

        // Attributes
        $atts = shortcode_atts(
            array(
                'columns'   => '3',
                'limit'     => '-1',
               
            ),
            $atts,
            'preorder_products'
        );


        $woocommerce_loop['columns'] = $atts['columns'];
            
        // The WP_Query
        //todo: variable preorder not showing
        $preorderQuery = new \WP_Query(array(
                'post_type'         => 'product',
                'post_status'       => 'publish',
                'posts_per_page'    => $atts['limit'],
                'meta_query'        => array(
                   
                    array(
                    'key'   => '_is_pre_order',
                    'value' => 'yes',
                    'compare' => '='
                    ),
                    array(
                        'key'     => '_pre_order_date',
                        'value'   => date('y-m-d'),
                        'compare' => '>=',
                        'type'  => 'DATE'
                    ),
                ),
            ));

        ob_start();

        if ($preorderQuery->have_posts()) {
            woocommerce_product_loop_start();

            while ($preorderQuery->have_posts()) : $preorderQuery->the_post();

            wc_get_template_part('content', 'product');

            
            endwhile; // end of the loop.

            woocommerce_product_loop_end();
        } else {
            do_action("woocommerce_shortcode_products_loop_no_results", $atts);
            echo "<p>".__('No preorder products found.', 'preoders')."</p>";
        }

        woocommerce_reset_loop();

        wp_reset_postdata();

        return '<div class="woocommerce columns-' . $atts['columns'] . '">' . ob_get_clean() . '</div>';
    }
    /**
     * List of all active payment gateway
     *
     * @return array
     */
    public static function paymentGatewayList()
    {
        $active_gateways = array();
        $gateways        = WC()->payment_gateways->payment_gateways();
        foreach ($gateways as $id => $gateway) {
            if (isset($gateway->enabled) && 'yes' === $gateway->enabled) {
                $active_gateways[ $id ] = $gateway->title;
            }
        }

        return $active_gateways;
    }
    /**
     * Check if cart have preorder products item
     * @return boolen
     */
    public static function cartHasPreorderItems()
    {
        $cartItems = [];
        foreach (WC()->cart->get_cart() as $cart_item_key => $cartItem) {
            $cartItems[] = (get_post_meta($cartItem['product_id'], '_is_pre_order', true) == 'yes') ? 'yes' : null ;
        }
        
        if (in_array('yes', $cartItems)) {
            return true;
        }
        
        return false;
    }

    public function defaultOptions()
    {
        $defaultOptions = [
            'wc_preorders_button_text' => 'Pre Order Now!',
            'wc_preorders_change_button' => 'yes',
            'wc_preorders_prevent_shipping_cost' => 'no',
            'wc_preorders_always_choose_date' => 'yes',
            'wc_preorders_mode' => 'whole',
            'wc_preorders_after_completed' => 'wc-processing',
            'wc_preorders_multiply_shipping' => 'no',
            'wc_preorders_license_email' => '',
            'wc_preorders_product_date_cycle' => 'instock',
            'wc_preorders_license_key' => '',
            'wc_preorders_is_pro' => 'no',
            'wc_preorders_avaiable_date_single_product' => 'yes',
            'wc_preorders_avaiable_date_loop' => 'yes',
            'wc_preorders_avaiable_date_checkout_item' => 'yes',
            'wc_preorders_avaiable_date_cart_item' => 'yes',
        ];

        foreach ($defaultOptions as $option => $value) {
            if (!get_option($option) || '' === get_option($option)) {
                add_option($option, $value);
            }
        }
    }
    public function onDeactivation()
    {
        wp_clear_scheduled_hook('check_for_released_preorders');
        wp_clear_scheduled_hook('send_preorder_email_alert');
        wp_clear_scheduled_hook('wc_send_pre_order_available_email');
        wp_clear_scheduled_hook('wc_check_parent_order_status');
    }

    public function adminEnqueueScripts()
    {
        wp_enqueue_script(
            'preorders-field-date-js',
            WCPO_PLUGIN_URL.'media/js/date-picker.js',
            ['jquery', 'jquery-ui-core', 'jquery-ui-datepicker'],
            time(),
            true
        );
    }

    public function frontEnqueueStyles()
    {
        wp_register_style('woocommerce-pre-orders-main-css', WCPO_PLUGIN_URL.'media/css/main.css');
        wp_enqueue_style('woocommerce-pre-orders-main-css');
        if (is_checkout()) {
            wp_enqueue_style('jquery-ui', WC()->plugin_url() . '/assets/css/jquery-ui/jquery-ui.min.css', [], null);
        }
    }

    public function frontEnqueueScripts()
    {
        wp_enqueue_script(
            'preorders-field-date-js',
            WCPO_PLUGIN_URL.'media/js/date-picker.js',
            ['jquery', 'jquery-ui-core', 'jquery-ui-datepicker'],
            WCPO_PLUGIN_VER,
            true
        );

        $data = [
            'default_add_to_cart_text' => __('Add to cart', 'preorders-for-woocommerce-pro'),
            'preorders_add_to_cart_text' => get_option('wc_preorders_button_text'),
            'preorder_avaiable_date' => get_option('wc_preorders_avaiable_date_text'),
        ];

        wp_register_script(
            'preorders-main-js',
            WCPO_PLUGIN_URL.'media/js/main.js',
            ['jquery'],
            WCPO_PLUGIN_VER,
            true
        );
        wp_register_script(
            'multi-countdown',
            WCPO_PLUGIN_URL.'media/js/multi-countdown.js',
            ['jquery'],
            WCPO_PLUGIN_VER,
            true
        );

        wp_enqueue_script('multi-countdown');

        wp_localize_script('preorders-main-js', 'DBData', $data);

        wp_enqueue_script(
            'preorders-main-js'
        );
    }

    public function adminEnqueueStyles()
    {
        wp_enqueue_style('jquery-ui');
        wp_enqueue_style('preorder-admin', WCPO_PLUGIN_URL.'media/css/admin.css', null, WCPO_PLUGIN_VER);
    }

    public function generatePreOrderStatus()
    {
        $statusManager = new StatusManager([
            'statusName' => 'pre-ordered',
            'label' => 'Pre Ordered',
            'labelCount' => _n_noop('Pre Ordered <span class="count">(%s)</span>', 'Pre Ordered <span class="count">(%s)</span>', 'preorders-for-woocommerce-pro'),
        ]);
        $statusManager->save();
    }

    public function initializeCheckout()
    {
        new Checkout();
    }

    public function initializeSync()
    {
        new Sync();
    }

    public function initializeTabs()
    {
        new Tabs();
    }

    public function initializeNotices()
    {
        new Notices();
    }

    public function initialProductTaxonomy()
    {
        new ProductTaxonomy();
    }

    public function initializeSettings()
    {
        new Settings();
    }

    public function initializeShop()
    {
        new Shop();
    }
    public function initializeCoupons()
    {
        new Coupons();
    }

    public function initializeOrder()
    {
        new Order();
    }

    public function initializeUpdates()
    {
        new pluginUpdater();
    }
}
