<?php

namespace Woocommerce_Preorders;

class Backend
{
    public function __construct()
    {
        add_action('restrict_manage_posts', [$this, 'preoderProductFilter']);
        add_action('pre_get_posts', [$this, 'preoderProductQuery']);
        add_action('manage_product_posts_custom_column', [$this, 'preorderColumn'], 10, 2);
        add_filter('manage_product_posts_columns', [$this, 'addPreroderColumn']);
    }

    public function preorderColumn($column, $productId)
    {
        switch ($column) {

            case 'preorder':
                $preorderCheckbox = get_post_meta($productId, '_is_pre_order', true);
                $preorderDate = get_post_meta($productId, '_pre_order_date', true);
                $preorderDateF = date_format(date_create($preorderDate), apply_filters('product_preorder_date_format', get_option('date_format')));

                if ($preorderCheckbox == 'yes' && $preorderDate >= date("Y-m-d")) {
                    echo '<span class="product-preorder-upcoming">'.$preorderDateF.'</span>' ;
                } elseif ($preorderCheckbox == 'yes' && $preorderDate < date("Y-m-d")) {
                    echo '<span class="product-preorder-expired">'.$preorderDateF.'</span>' ;
                }
                break;

        }
    }
    public function addPreroderColumn($columns)
    {
        $columns['preorder'] = __('Preorder Date', 'preorders-for-woocommerce-pro');
        return $columns;
    }
    public function preoderProductQuery($query)
    {
        global $pagenow;
        $meta_key_query = [];

        // Ensure it is an edit.php admin page, the filter exists and has a value, and that it's the products page
        if ($query->is_admin && $pagenow == 'edit.php' && isset($_GET['preorder']) && $_GET['preorder'] == 'active' && $_GET['post_type'] == 'product') {
            $meta_key_query = array(
                'relation' => 'AND',
                array(
                    'key'   => '_is_pre_order',
                    'value' => 'yes',
                ),
                array(
                    'key'     => '_pre_order_date',
                    'value'   => date('y-m-d'),
                    'compare' => '>=',
                    'type'  => 'DATE'
                ),
            );

            $query->set('meta_query', $meta_key_query);
        } elseif ($query->is_admin && $pagenow == 'edit.php' && isset($_GET['preorder']) && $_GET['preorder'] == 'all' && $_GET['post_type'] == 'product') {
            $meta_key_query = array(
                
                array(
                    'key'   => '_is_pre_order',
                    'value' => 'yes',
                ),
              
            );

            $query->set('meta_query', $meta_key_query);
        }


        if (isset($_GET['preorder']) && $_GET['preorder'] != '' && isset($_GET['product_type']) && $_GET['product_type'] == 'variable') {
            //todo: not working for variable products query
        }
    }

    public function preoderProductFilter($postType)
    {
        $value = '';

        // Check if filter has been applied already so we can adjust the input element accordingly

        if (isset($_GET['preorder'])) {
            switch ($_GET['preorder']) {

            // We will add the "selected" attribute to the appropriate <option> if the filter has already been applied
            case 'active':
            $value = ' selected';
            break;

            case 'all':
            $value = ' selected';
            break;
        }
        }

        // Check this is the products screen
        if ($postType == 'product') {

        // Add your filter input here. Make sure the input name matches the $_GET value you are checking above.
            echo '<select name="preorder">';

            echo '<option value>Filter by Pre Orders</option>';
            echo '<option value="active"' . $value . '>'.__('Show active Pre Orders', 'preorders-for-woocommerce-pro').'</option>';
            echo '<option value="all"' . $value . '>'.__('Show all Pre Orders', 'preorders-for-woocommerce-pro').'</option>';

            echo '</select>';
        }
    }
}
