<?php
/**
 * Plugin Name: Preorders for WooCommerce PRO
 * Plugin URI: https://brightplugins.com/
 * Description: Ultimate Preorders Plugin for WooCommerce.
 * Version: 1.5
 * Author: Bright Plugins
 * Requires PHP: 7.2.0
 * Requires at least: 4.9
 * Tested up to: 5.7.2
 * WC tested up to: 5.2.2
 * WC requires at least: 3.9
 * Author URI: https://brightplugins.com
 * Text Domain: preorders-for-woocommerce-pro
 * Domain Path: /etc/i18n/languages/.
 */

defined('ABSPATH') || exit;


require_once ABSPATH . 'wp-admin/includes/plugin.php';
require_once __DIR__.'/vendor/autoload.php';



// Check if the free version is enabled, and if so, disable it
if (in_array('pre-orders-for-woocommerce/main.php', apply_filters('active_plugins', get_option('active_plugins')), true)) {
    deactivate_plugins('pre-orders-for-woocommerce/main.php');
}

// Define WCPO_PLUGIN_DIR.
if (!defined('WCPO_PLUGIN_DIR')) {
    define('WCPO_PLUGIN_DIR', __DIR__);
}

define('WCPO_TEMPLATE_PATH', untrailingslashit(plugin_dir_path(__FILE__)) . '/templates/');

if (!defined('WCPO_PLUGIN_FILE')) {
    define('WCPO_PLUGIN_FILE', __FILE__);
}

if (!defined('WCPO_PLUGIN_BASE')) {
    define('WCPO_PLUGIN_BASE', plugin_basename(__FILE__));

    $bvpoPluginData = get_plugin_data(__FILE__);
    define('WCPO_PLUGIN_VER', $bvpoPluginData['Version']);
}


use Woocommerce_Preorders\Bootstrap;
use Woocommerce_Preorders\Packages;

// Check if WooCommerce is active
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')), true)) {
    add_action('woocommerce_loaded', function () {
        require_once WCPO_PLUGIN_DIR.'/etc/conf.php';

        $bootstrap = new Bootstrap();
        register_activation_hook(__FILE__, [$bootstrap, 'defaultOptions']);
        register_deactivation_hook(__FILE__, [$bootstrap, 'onDeactivation']);

        $package = new Packages();
        if (!get_option('pofwc_plugin_activation')) {
            update_option('pofwc_plugin_activation', current_time('timestamp'));
        }
    });
} else {
    add_action('admin_notices', function () {
        $class = 'notice notice-error';
        $message = __('Oops! looks like WooCommerce is disabled. Please, enable it in order to use WooCommerce Pre-Orders.', 'preorders-for-woocommerce-pro');
        printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
    });
}
