<?php

if (!defined('WCPO_PLUGIN_URL')) {
    define('WCPO_PLUGIN_URL', plugin_dir_url(__FILE__) . '../');
}

add_action('plugins_loaded', function () {
    load_plugin_textdomain('preorders-for-woocommerce-pro', false, basename(dirname(__FILE__)) . '/i18n');
});

// Cron interval. Default = once per hour
define('WCPO_CRON_INTERVAL', 'hourly');

// Define our license server
define('WCPO_LICENSE_SERVER', 'http://licenses.brightplugins.com/');

// Load custom e-mails
function wcpoAddPreordersCustomEmail($email_classes)
{
    // include our custom email class
    require_once WCPO_PLUGIN_DIR . '/src/emails/class-wc-email-customer-preorder-available.php';
    require_once WCPO_PLUGIN_DIR . '/src/emails/class-wc-email-new-preorder.php';
    require_once WCPO_PLUGIN_DIR . '/src/emails/class-wc-email-preorder-alert.php';
    require_once WCPO_PLUGIN_DIR . '/src/emails/class-wc-email-customer-preorder.php';

    // add the email class to the list of email classes that WooCommerce loads
    $email_classes['WC_New_Customer_Pre_Order_Email'] = new WC_Email_Customer_PreOrder();
    $email_classes['WC_New_Pre_Order_Email'] = new WC_Email_New_Pre_Order();
    $email_classes['WC_Pre_Order_Alert'] = new WC_Email_Pre_Order_Alert();
    $email_classes['WC_Preorder_Ready'] = new WC_Preorder_Ready();

    return $email_classes;
}
add_filter('woocommerce_email_classes', 'wcpoAddPreordersCustomEmail', 90);

if (in_array('woocommerce-product-bundles/woocommerce-product-bundles.php', apply_filters('active_plugins', get_option('active_plugins')), true)) {
    // TODO: compatibility with product bundles
}
