<?php

namespace Blue2\Scruffy\Order;

use Blue2\Scruffy\Controllers\TradeController;

class Order
{
    private $orderData;

    public function __construct($orderData)
    {
        $this->orderData = $orderData;
    }

    public function getOrderID()
    {
        return $this->orderData->get_id();
    }

    public function getOrderData()
    {
        return $this->orderData->get_data();
    }

    public function getName()
    {
        return $this->getOrderData()['billing']['first_name'] . ' ' . $this->getOrderData()['billing']['last_name'];
    }

    public function getEmail()
    {
        return $this->getOrderData()['billing']['email'];
    }

    public function getPhoneNumber()
    {
        return $this->getOrderData()['billing']['phone'];
    }
    public function getOrderType()
    {
        return $this->orderData->get_type();
    }

    public function getOrderStatus()
    {
        $statuses = wc_get_order_statuses();

        return $statuses['wc-'.$this->orderData->get_status()];
    }

    public function getOrderDate()
    {
        return $this->orderData->get_date_created();
    }

    public function getCustomerNote()
    {
        return $this->orderData->get_customer_note();
    }

    public function getTotal()
    {
        return $this->orderData->get_total();
    }

    public function getOrderItems()
    {
        return $this->orderData->get_items();
    }

    public function getFinalPrice()
    {
        $finalPrice = new FinalPrice($this->getOrderData());
        return $finalPrice->getFinalPrice();
    }

    public function newOrderData()
    {
        $newOrderArray = [
            'id' => $this->getOrderID(),
            'date_placed' => $this->getOrderDate()->format('Y-m-d H:i:s'),
            'customer_name' => $this->getName(),
            'customer_email' => $this->getEmail(),
            'customer_phone' => $this->getPhoneNumber(),
            'deliver_to' => str_replace('<br/>', ', ', $this->getShippingAddress()),
            'status' => $this->getOrderStatus(),
            'final_price' => $this->getFinalPrice(),
            'estimated_price' => $this->getTotal(),
            'is_trade' => TradeController::isTradeCustomer($this->orderData->user_id),
            '$css' => TradeController::isTradeCustomer($this->orderData->user_id) ? 'trade-order' : '',
            '$cellCss' => [
                'banner'=> TradeController::isTradeCustomer($this->orderData->user_id) ? 'trade-banner' : ''
            ]
        ];

        return $newOrderArray;
    }

    public function getDeliveryName()
    {
        if ($this->orderData->has_shipping_address()) {
            return $this->getOrderData()['shipping']['first_name'] . ' ' . $this->getOrderData()['shipping']['last_name'];
        }

        return $this->getName();
    }

    public function getShippingAddress($single = false)
    {
        if ($this->orderData->get_formatted_shipping_address()) {
            $address =  $this->orderData->get_formatted_shipping_address();
        } else {
            $address =  $this->orderData->get_formatted_billing_address();
        }

        return $single ? str_replace('<br/>', ', ', $address) : $address;
    }

    public function getBillingAddress($single = false)
    {
        $address = $this->orderData->get_formatted_billing_address();

        return $single ? str_replace('<br/>', ', ', $address) : $address;
    }
}
