
<?php
$filters = Blue2\Scruffy\Controllers\OrderDashboardController::getFilters();
$filters['date_to'] = $filters['date_to'] ? $filters['date_to']->format('Y-m-d') : null;
$filters['date_from'] = $filters['date_from'] ? $filters['date_from']->format('Y-m-d') : null;
?>

<h1>Find Orders</h1>

<script>
let data = [];
const filters = <?= json_encode($filters) ?>;
 </script>

<form action="/order-dashboard/" method="get" class="order_form">
    <div class="row">
        <div class="col-xl-5 form-group row order-2 order-xl-1">
            <label for="search" class="col-sm-2 col-form-label">Search</label>
            <div class="col-sm-10">
                <input type="text" class="form-control" id="search" name="order_search" placeholder="Enter order id or customer details" value="<?= $filters['order_search'] ?>">
            </div>
        </div>
        <div class="col-xl-5 form-group row order-1 order-xl-2">
            <label for="date_filter" class="col-sm-2 col-form-label">Filter by</label>
            <div class="col-sm-10">
                <select class="form-control" id="date_filter" name="date_filter" >
                    <option value="ordered" <?= $filters['date_filter'] == 'shipped' ? 'selected' : '' ?>>Date Ordered</option>
                    <option value="shipped" <?= $filters['date_filter'] == 'shipped' ? 'selected' : '' ?> >Date Shipped</option>
                </select>
            </div>
        </div>
        <div class="col-xl-2 form-group row order-6 order-xl-3">
            <input type="submit" value="Search" class="btn btn-primary">
        </div>

        <div class="col-xl-5 form-group row order-3 order-xl-4">
            <label for="status" class="col-sm-2 col-form-label">Status</label>
            <div class="col-sm-10">
                <select class="form-control" id="status" name="status" >
                    <option value="">All</option>
                    <option value="unprocessed" <?= $filters['status'] == 'unprocessed' ? 'selected' : '' ?>>Unprocessed</option>
                    <option value="processing" <?= $filters['status'] == 'processing' ? 'selected' : '' ?>>Processing</option>
                    <option value="shipped" <?= $filters['status'] == 'shipped' ? 'selected' : '' ?>>Shipped</option>
                    <option value="cancelled" <?= $filters['status'] == 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                </select>
            </div>
        </div>

        <div class="col-xl-5 form-group row order-4 order-xl-5">
            <label for="date_from" class="col-2 col-form-label">From</label>
            <div class="col-sm-4">
                <input type="date" class="form-control" id="date_from" name="date_from"  value="<?= $filters['date_from'] ?>" placeholder="yyyy-mm-dd" />
            </div>
            <label for="date_to" class="col-2 col-form-label">To</label>
            <div class="col-sm-4">
                <input type="date" class="form-control" id="date_to" name="date_to"  value="<?= $filters['date_to'] ?>" placeholder="yyyy-mm-dd" />
            </div>
        </div>
    </div>
</form>

<div id="boxcontainer">
</div>
<div id="order_pager">
</div>
