<?php
$userId = get_current_user_id();
if ($userId) { ?>
    <div class="custom-favourite-block">
        <div class="top">
            <h2>My Favourite Products</h2>
        </div>
        <ul class="products columns-4 favourite-row">
            <?php
            $favouriteProducts = get_field('favourite_products', 'user_' . $userId);
            $args = [
                'post_type' => 'product',
                'post__in' => $favouriteProducts
            ];
            $loop = new WP_Query( $args );
            if($favouriteProducts) {
                while ($loop->have_posts()) {
                    $loop->the_post();
                    global $product;?>
                    <span class="favourite-col">
                        <?php wc_get_template_part('content', 'product'); ?>
                    </span>

                 <?php } wp_reset_postdata();
            } else { ?>
            <div class="no-rows">You do not have any favourite products...</div>
            <?php } ?>
        </ul>
    </div>
<?php } ?>
