<?php
use Blue2\Scruffy\Site;
use Blue2\Scruffy\Order\Order;
use Blue2\Scruffy\Order\OrderItem;

$orderId = get_query_var('orderId') ?? null;
$wooOrder = wc_get_order($orderId);
$order = new Order($wooOrder);
$trackingNumber = Site::isUSSite() ? get_post_meta($orderId, 'wf_woo_fedex_shipmentId', true) : get_post_meta($orderId, 'ups_shipment_ids', true);

$cancel_nonce = wp_create_nonce('wp_rest');
?>
<ul class="custom-order-breadcrumbs">
    <li>Processing</li>
    <?php $batch = get_field('batch', $orderId);
    if ($batch) { ?>
        <li><?= $batch->post_title ?></li>
    <?php } ?>
    <li>Order <?= $orderId ?></li>
</ul>

<h1>Order <?= $orderId ?></h1>
<div class="order-buttons">
    <div class="row row-eq-height">
        <div class="col-sm-6 col-lg-3 button-col">
            <a class="btn btn-primary" href='/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/receipt-plain?_wpnonce=<?= esc_attr($cancel_nonce) ?>' target="_blank">Print Receipt (Plain)</a>
        </div>
        <div class="col-sm-6 col-lg-3 button-col">
            <a class="btn btn-primary" href='/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/receipt-letterhead?_wpnonce=<?= esc_attr($cancel_nonce) ?>' target="_blank">Print Receipt (Letterhead)</a>
        </div>
        <?php if (get_post_meta($orderId, 'is_gift', true)) { ?>
        <div class="col-sm-6 col-lg-3 button-col">
            <a class="btn btn-primary" href='/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/gift-message?_wpnonce=<?= esc_attr($cancel_nonce) ?>' target="_blank">Print Gift Message</a>
        </div>
        <?php } ?>
        <div class="col-sm-6 col-lg-3 button-col">
            <a class="btn btn-primary cancel-order" href='/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/cancel-order?_wpnonce=<?= esc_attr($cancel_nonce) ?>'>Cancel Order</a>
        </div>
        <div class="col-sm-6 col-lg-3 button-col">
            <a class="btn btn-primary" data-toggle="collapse" href="#collapseExample" role="button" >Record Refund</a>
        </div>
    </div>
</div>

<div class="row justify-content-end">
    <div class="col-3">
        <div class="collapse" id="collapseExample">
            <form id='refundForm' action="/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/refund-order" method="post">
                <div class="form-group">
                    <label for="refund_total">Total to Refund</label>
                    <input type="text" name="refund_total" class="form-control" id="refund_total" placeholder="0.00">
                </div>
                <input type="hidden" name="_wpnonce" value="<?= esc_attr($cancel_nonce) ?>"/>
                <button type="submit" class="btn btn-primary">Submit</button>
            </form>
        </div>
    </div>
</div>

<div class="detail-blocks">
    <div class="row row-eq-height">
        <div class="col-lg-12 col-xl-4 order-box-col mb-2">
            <div class="single-order-box">
                <h2>Order Details</h2>
                <!-- todo - add order details -->
                <div class="details">
                <table>
                    <tr><th>Order reference</th><td><?= $orderId ?></td></tr>
                    <tr><th>Status</th><td><?= wc_get_order_status_name($wooOrder->get_status()) ?></td></tr>
                    <tr><th>Order date</th><td><?= $wooOrder->get_date_created()->format('jS F Y') ?></td></tr>
                    <tr><th>Order time</th><td><?= $wooOrder->get_date_created()->format('g:i a') ?></td></tr>
                    <tr><th>Tracking number</th><td><?= $trackingNumber ?></td></tr>
                    <tr><th>Delivery type</th><td><?= $wooOrder->get_shipping_method();?></td></tr>
                    <tr><th>Order notes</th><td><?= @$wooOrder->post->post_excerpt; ?></td></tr>
                </table>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-xl-4 order-box-col mb-2">
            <div class="single-order-box">
                <h2>Billing Address</h2>

                <div class="details">
                    <p><?= $order->getBillingAddress(); ?></p>
                    <p><?= $order->getEmail(); ?></p>
                    <p><?= $order->getPhoneNumber(); ?></p>
                </div>
            </div>
        </div>

        <?php
        $shippingAddresses = Blue2\Scruffy\Controllers\OrderDashboardController::getShippingAddresses($wooOrder);
        if (count($shippingAddresses) > 0) {
            foreach ($shippingAddresses as $shippingAddress) {
                ?>
        <div class="col-lg-12 col-xl-4 order-box-col mb-2">
                <div class="single-order-box">
                    <h2>Delivery Address</h2>
                    <div class="details">
                        <?= $shippingAddress; ?>
                    </div>
                </div>
            </div>
                <?php
            }
        } else {
            ?>
        <div class="col-lg-12 col-xl-4 order-box-col mb-2">
            <div class="single-order-box">
                <h2>Delivery Address</h2>
                <div class="details">
                    <?= $order->getShippingAddress(); ?>
                </div>
            </div>
        </div>
        <?php
        } ?>
    </div>
</div>

<div class="tracking-block">
    <h2>Tracking Number</h2>
    <?php
    $storedPackages = Site::isUSSite() ? get_post_meta($orderId, '_wf_fedex_stored_packages', true) : get_post_meta($orderId, '_wf_ups_stored_packages', true);
    $shippingCosts = Blue2\Scruffy\Controllers\OrderDashboardController::getShippingCosts($orderId);
    ?>
    <p>Number of calculated boxes: <?= is_array($storedPackages) ? count($storedPackages) : 'N/A' ?></p>
    <p>Estimated shipping cost: <?= $shippingCosts ?></p>

<?php

    if ($trackingNumber != '') {
        ?>
        <p>Tracking Number: <?= $trackingNumber ?></p>

        <?php

        if (Site::isUSSite()) {
            $shipmentIds = get_post_meta($orderId, 'wf_woo_fedex_shipmentId', false);
            
            foreach ($shipmentIds as $shipmentId) {
                $download_url = admin_url('/post.php?wf_fedex_viewlabel='.base64_encode($shipmentId.'|'.$orderId)); ?>
            <a class="btn btn-primary" href="<?= $download_url; ?>">Download Label</a>
        <?php
            }
        } else {
            $ups_label_details_array = get_post_meta($orderId, 'ups_label_details_array', true);
            $index = 0;
            if (is_array($ups_label_details_array)) {
                foreach ($ups_label_details_array as $trackingNumber => $ups_label_details) {
                    foreach ($ups_label_details as $ups_label_detail) {
                        $label_extn_code 	= $ups_label_detail["Code"];
                        $tracking_number 	= isset($ups_label_detail["TrackingNumber"]) ? $ups_label_detail["TrackingNumber"] : '';
                        $download_url 		= admin_url('/?wf_ups_print_label='.base64_encode($trackingNumber.'|'.$orderId.'|'.$label_extn_code.'|'.$index.'|'.$tracking_number));
                        $index++; ?>

                <a class="btn btn-primary" href="<?= $download_url ?>">Download Label</a>
                <?php
                    }
                }
            }
        } ?>
        <?php
    } else {
        ?>
        <div class="d-flex">
            <a class="btn btn-primary w-auto mr-3" href='/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/create-tracking?_wpnonce=<?= esc_attr($cancel_nonce) ?>'>Generate Tracking Number/Mark Order Complete</a>
            <form action="/wp-json/walkers/v1/<?= $wooOrder->get_id() ?>/add-tracking?_wpnonce=<?= esc_attr($cancel_nonce) ?>" method="post" class="flex-grow-1">
                <div class="input-group">
                    <input type="text" class="form-control h-auto" name="tracking" placeholder="Tracking number" aria-label="Tracking number" aria-describedby="button-addon2">
                    <div class="input-group-append">
                        <button class="btn btn-primary w-auto" type="submit" id="button-addon2">Add Tracking / Mark order complete</button>
                    </div>
                </div>
            </form>
    </div>
        <?php
    }
    ?>
</div>

<div class="product-blocks">
    <h2>Products</h2>
    <div class="inner-product-block">
        <table>
            <thead>
            <tr>
                <td>Product</td>
                <td></td>
                <td>Qty</td>
                <td>Price</td>
            </tr>
            </thead>
            <tbody>
            <?php

            foreach ($order->getOrderItems() as $wooOrderItem) {
                $result = wc_pb_get_bundled_order_item_container($wooOrderItem, $wooOrder);
                $orderItem = new OrderItem($wooOrderItem, '', $orderId); ?>
                <tr>
                    <td><img src="<?= $orderItem->getThumbnail() ?>" /></td>
                    <td class="<?= $result ? 'bundled-item' : '' ?>"><?= $orderItem->getOrderName() ?></td>
                    <td><?= $orderItem->getQuantity() ?></td>
                    <td><?= wc_price($orderItem->getTotal()) ?></td>
                </tr>
                <?php
            }
            ?>
            </tbody>
        </table>
    </div>
</div>

<div class="transaction-block">
    <h2>Transactions</h2>

    <table>
        <tr>
            <th>Time</th>
            <th>Provider & Code</th>
            <th>Notes</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Outcome</th>
        </tr>

        <?php
        $sageResult = get_post_meta($orderId, '_sageresult', true);
        if ($wooOrder->get_date_paid() !== '' && is_array($sageResult)) {
            ?>
            <tr>
                <td>
                    <?= $wooOrder->get_date_paid() ?>
                </td>
                <td>
                    <?= $sageResult['VPSTxId'] ?>
                </td>
                <td>Your order from Walkers Shortbread</td>
                <td>payment</td>
                <td>
                    <?= $sageResult['Amount'] ?>
                </td>
                <td>
                    <?= $sageResult['Status'] ?>
                </td>
            </tr>
            <?php
        }

        // Get all refunds
        $refunds = $wooOrder->get_refunds();

        // Loop over refunds
        foreach ($refunds as $refund) {
            ?>
            <tr>
                <td>
                    <?= $refund->get_date_created()->date('Y-m-d H:i:s') ?>
                </td>
                <td> Refund by
                    <?= get_author_name($refund->get_refunded_by()) ?>
                </td>
                <td>Your order from Walkers Shortbread</td>
                <td>refund</td>
                <td>
                    <?= $refund->get_amount() ?>
                </td>
                <td>
                    <?= $sageResult['Status'] ?>
                </td>
            </tr>
            <?php
        }

        ?>
    </table>
</div>
