<?php
$brand = get_field('brand');
// Get top level parent of this Brand.
if(!$brand){
    $brand = get_field('brand', wp_get_post_parent_id($post));
}
$ancestors = get_ancestors( $brand->term_id, 'brand' );
$ancestors = array_reverse($ancestors);
$ancestors[0] ? $top_term_id = $ancestors[0] : $top_term_id = $brand;
$term = get_term( $top_term_id, 'brand' );
$parentBrand = $term->name;

$bannerColour = get_field('banner_text_colour');
$banner = get_field('banner_images');

$scents = get_field('scent_of_the_month');
?>
<div class="collection-landing-page">
    <?php
    get_template_part('templates/parts/hero-banner');
    ?>    <?php
    get_template_part('templates/parts/popular-cats');
    ?>
    <section class="scent-of-the-month-details row-tint container-fluid">
        <div class="row">
            <?php
            if( $scents ): ?>
                <div class="swiper-container swiper-container--paused">
                    <div class="swiper-wrapper">
                        <?php foreach( $scents as $scent ): ?>
                            <div class="swiper-slide flex flex-wrap">
                                <div class="col-12 col-md-6 p-0">
                                    <?php
                                    // Grab default scent image from scent tax.
                                    $scentImg = get_field('scent_featured_image', 'scent_'.$scent->term_id);
                                    $size = 'large';
                                    $scentImgUrl = $scentImg['sizes'][ $size ];
                                    //Look for brand scent image in brands repeater.
                                    $scentImgRows = get_field('scents_images','brand_'.$brand->term_id);
                                    if( $scentImgRows ) {
                                        foreach( $scentImgRows as $scentImgRow ) {
                                            if( $scentImgRow['scent']->name == $scent->name ){
                                                $scentImg = $scentImgRow['scent_image'];
                                                $scentImgUrl = $scentImg['sizes'][ $size ];
                                                break;
                                            }
                                        }
                                    }
                                    ?>
                                    <div class="img-wrapper img-wrapper--fill img-framed">
                                        <img class="img-fluid" src="<?=$scentImgUrl;?>" alt="<?=$scentImg['title'];?>">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6">
                                    <div class="copy-col">
                                        <p class="sub-heading">Scent of the month</p>
                                        <h2><?=$scent->name;?></h2>
                                        <p><?= $scent->description;?></p>
                                        <a class="view-more-link" href="/index.php?post_type=product&brand=<?=$brand->slug;?>&scent=<?=$scent->slug;?>">Browse Products <i class="far fa-arrow-right"></i></a>
                                        <div class="swiper-pagination text-left"></div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php
    $promos = get_field('promoted_categories');
    if($promos){ ?>
        <section class="promoted-categories content-container">
            <div class="row">
                <div class="section__intro">
                    <?= $promos['introduction_text'];?>
                </div>
            </div>
            <div class="row flex-row row-wrap">
                <?php
                // Grab default scent image from scent tax.
                //Look for product cats in popular cats repeater.
                $promo_cats = $promos['brand_categories'];

                if( $promo_cats ) {
                    foreach( $promo_cats as $promo_cat ) {
                        $collections = $promo_cat['show_collections'];
                        if($collections){
                            $term = $promo_cat['collection'];
                            $tax='brand_';
                        }else{
                            $term = $promo_cat['category'];
                            $tax='product_cat_';
                        }
                        $imageUrl=null;
                        // Look for Category images with fallbacks.
                        // Get default Cat image
                        $thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
                        $imageUrl = wp_get_attachment_url( $thumbnail_id );

                        //Get image from Cat or Brand
                        if($collections){
                            $image = get_field('brand_featured_image',$tax.$term->term_id);
                            if($image){
                                $size = 'large';
                                $imageUrl=$image['sizes'][ $size ];
                            }
                        }else{
                            $catImgRows = get_field('category_image_by_brand',$tax.$term->term_id);
                            if( $catImgRows ) {
                                foreach( $catImgRows as $catImgRow ) {
                                    if( $catImgRow['brand']->name == $brand->name ){
                                        $image = $catImgRow['brand_category_image'];
                                        $size = 'large';
                                        $imageUrl=$image['sizes'][ $size ];
                                        break;
                                    }
                                }
                            }
                        }

                        // Get image from page if set.
                        if ($promo_cat['image']){
                            $image = $promo_cat['image'];
                            $size = 'large';
                            $imageUrl=$image['sizes'][ $size ];
                        }
                        if($collections){
                            $link = esc_url( get_term_link( $term ) );
                        }else{
                            $link = '/index.php?post_type=product&brand='.$brand->slug.'&product-category='.$term->slug;
                        }
                        ?>
                        <div class="cat-panel col text-center">
                            <a href="<?=$link;?>">
                                <div class="img-wrapper img-framed">
                                    <img class="img-fluid" src="<?=$imageUrl;?>" alt="<?=$term->name;?>">
                                </div>
                                <h2><?php echo esc_html( $term->name ); ?></h2>
                                <p><?php echo esc_html( $term->description ); ?></p>
                            </a>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </section>
        <?php
    }
    ?>
    <?php
    get_template_part('templates/parts/scents-of-the-month-carousel');
    ?>
    <?php
    get_template_part('templates/parts/feature-row');
    ?>
    <?php
    get_template_part('templates/parts/brands-carousel');
    ?>
    <?php
    get_template_part('templates/parts/membership-cta');
    ?>
</div>
