<?php
    $brand = get_field('brand');
    // Get top level parent of this Brand.
    $ancestors = get_ancestors( $brand->term_id, 'brand' );
    $ancestors = array_reverse($ancestors);
    $ancestors[0] ? $top_term_id = $ancestors[0] : $top_term_id = $brand;
    $term = get_term( $top_term_id, 'brand' );
    $parentBrand = $term->name;

    $bannerColour = get_field('banner_text_colour');
    $banner = get_field('banner_images');
    
    $scents = get_field('scent_of_the_month','brand_'.$brand->term_id);
    // Check if brand scents are to be overridden on this page.
    if(get_field('selected_scents') == true){
        $scents = get_field('scent_of_the_month');
    }
    
    $scentPageArgs = array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'template-scent-of-the-month.php',
                'hierarchical' => 0,
                'parent' => $post->ID,
                'post_status'  => 'publish'
            );

    $scentPages = get_pages($scentPageArgs);
    $scentPageUrls=[];
    // Should only be 1 result.
    foreach( $scentPages as $scentPage ){
        array_push($scentPageUrls,get_permalink($scentPage->post_id));
    }
    if (count($scentPageUrls)>0){
        $scentPageUrl = $scentPageUrls[0];
    }
    ?>    
<div class="brand-landing-page">
    <div class="hero-banner hero-banner--<?=$bannerColour;?>-text">
        <div class="copy">
            <p class="department-name"><?=$parentBrand;?></p>
            <h1><?php the_title();?></h1>
            <a class="btn btn-primary btn-primary--inverse" href="/brand/<?=$brand->slug?>">Browse the products</a>
        </div>
        <?php if( have_rows('banner_images') ): ?>
            <div class="hero-banner__slides swiper-container swiper-container--paused">
                <div class="swiper-wrapper">

            <?php while( have_rows('banner_images') ): the_row();
                $image = get_sub_field('banner_image');
                ?>
                <div class="swiper-slide">
                    <img src="<?=$image['url'];?>" alt="<?=$image['title'];?>">
                </div>
            <?php endwhile; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        <?php endif; ?>
    </div>
    <?php
        get_template_part('templates/parts/popular-cats');
    ?>
    <section class="scent-of-the-month-details row-tint container-fluid">
        <div class="row">
            <?php
            if( $scents ): 
                $i=0;
            ?>
            <div class="swiper-container swiper-container--autoplay">
                <div class="swiper-wrapper">
                <?php foreach( $scents as $scent ): 
                    if($scentPageUrl){
                        $scentUrl = $scentPageUrl.'#scent--'.$scent->slug;
                    }else{
                        $scentUrl = get_category_link($scent->term_id);
                    }
                ?>
                    <div class="swiper-slide flex flex-wrap">
                         <div class="col-12 col-md-6 p-0">
                                <?php
                                    // Grab default scent image from scent tax.
                                    $scentImg = get_field('scent_featured_image', 'scent_'.$scent->term_id);
                                    $size = 'large';
                                    $scentImgUrl = $scentImg['sizes'][ $size ];
                                    //Look for brand scent image in brands repeater.
                                    $scentImgRows = get_field('scents_images','brand_'.$brand->term_id);
                                    if( $scentImgRows ) {
                                        foreach( $scentImgRows as $scentImgRow ) {
                                            if( $scentImgRow['scent']->name == $scent->name ){
                                                $scentImg = $scentImgRow['scent_image'];
                                                $scentImgUrl = $scentImg['sizes'][ $size ];
                                                break;
                                            }
                                        }
                                    }
                                ?>
                                <div class="img-wrapper img-wrapper--fill img-framed">
                                    <img class="img-fluid" src="<?=$scentImgUrl;?>" alt="<?=$scentImg['title'];?>">
                                </div>
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="copy-col">
                                    <p class="sub-heading">Scent of the month</p>
                                    <h2><?=$scent->name;?></h2>
                                    <p><?= $scent->description;?></p>
                                    <a class="view-more-link" href="<?= $scentUrl; ?>">Browse Products <i class="far fa-arrow-right"></i></a>
                                    <div class="swiper-pagination text-left"></div>
                                </div>
                            </div>
                    </div>
                <?php endforeach; ?>
                </div>

        </div>
        <?php endif; ?>
        </div>
    </section>
 <?php
        get_template_part('templates/parts/promoted-row');
    ?>
    <?php
        get_template_part('templates/parts/membership-cta');
    ?>
    <?php
        get_template_part('templates/parts/brands-carousel');
    ?>
</div>
