<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\OrderDashboardController;
use Blue2\Scruffy\Controllers\ShopController;
use Blue2\Scruffy\Controllers\FavouriteController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('woocommerce');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);
        add_action('init', [$this, 'registerTaxonomies']);
        add_filter( 'woocommerce_product_add_to_cart_text', [$this, 'woocommerce_custom_product_add_to_cart_text']);
        add_action('restrict_manage_posts', [$this, 'filter_post_type_by_taxonomy']);
        add_filter('parse_query', [$this, 'convert_id_to_term_in_query']);
        add_filter('woocommerce_catalog_orderby', [$this, 'wc_customize_product_sorting']);
        add_filter( 'woocommerce_add_to_cart_fragments', [$this, 'cart_count_fragments'] );
        add_action('wp_ajax_cloadmore', [$this, 'comments_loadmore_handler'] ); // wp_ajax_{action}
        add_action('wp_ajax_nopriv_cloadmore', [$this,'comments_loadmore_handler']); // wp_ajax_nopriv_{action}

        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
        $this->registerShortCodes();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        add_shortcode('order_dashboard', [$this->orderDashboardController, 'createOrderDashboard']);
    }

    private function registerFilters(){
        add_filter( 'woocommerce_product_tabs', [$this, 'woo_remove_product_tabs'], 98 );
        add_filter('pre_get_posts', [$this, 'updatingSearchPageParameters']);
    }

    private function registerActions() {
        add_action('wp_head', [$this, 'loadGlobalVar']);

        add_action('init', [$this, 'registerPostTypes']);
    }

    private function setupControllers(){
        new ShopController();
        new FavouriteController();
        $this->orderDashboardController = new OrderDashboardController();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
    }

    public function registerTaxonomies()
    {
        //new Taxonomy\Department();
        new Taxonomy\Brand();
        new Taxonomy\Scent();
    }
    public function woocommerce_custom_product_add_to_cart_text()
    {
        return __( 'Quick Buy', 'woocommerce' );
    }

    function woo_remove_product_tabs( $tabs ) {
        unset($tabs['reviews']);

        $tabs['additional_information']['callback'] = [$this, 'further_details_tab'];

        $tabs['delivery_tab'] = array(
            'title'     => __( 'Delivery', 'woocommerce' ),
            'priority'  => 50,
            'callback'  => [$this, 'delivery_tab']
        );

        return $tabs;
    }

    function further_details_tab() {
        global $product;

        $furtherDetails = get_field('further_details', $product->get_ID());

        echo '<h2>Further Details</h2>';
        echo $furtherDetails;

        if (empty($furtherDetails)) {
            echo '<style>.woocommerce-Tabs-panel--additional_information { display: none !important; }</style>';
        } else {
            echo '<style>.woocommerce-Tabs-panel--additional_information { display: block !important; }</style>';
        }
    }

    function delivery_tab() {
        $shopDelivery = get_field('shop_delivery', 'options');
        global $product;
        if ( $product->slug !== 'gift-card' ) {
            echo '<h2>Delivery</h2>';
            echo $shopDelivery;
    
            if (empty($shopDelivery)) {
                echo '<style>.woocommerce-Tabs-panel--delivery_tab { display: none !important; }</style>';
            } else {
                echo '<style>.woocommerce-Tabs-panel--delivery_tab { display: block !important; }</style>';
            }
        }
    }

    function updatingSearchPageParameters($query) {
        if ($query->is_search && !is_admin()) {
            $query->set('post_type', 'product');
            $query->set('wc_query', 'product_query' );
            $query->set('posts_per_page', 16 );
        }
        return $query;
    }
    
    function filter_post_type_by_taxonomy() {
    	global $typenow;
    	$post_type = 'product'; // change to your post type
    	$taxonomy  = 'brand'; // change to your taxonomy
    	if ($typenow == $post_type) {
    		$selected      = isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '';
    		$info_taxonomy = get_taxonomy($taxonomy);
    		wp_dropdown_categories(array(
    			'show_option_all' => sprintf( __( 'Show all %s', 'textdomain' ), $info_taxonomy->label ),
    			'taxonomy'        => $taxonomy,
    			'name'            => $taxonomy,
    			'orderby'         => 'name',
    			'selected'        => $selected,
    			'show_count'      => true,
    			'hide_empty'      => true,
    		));
    	};
    }
    function convert_id_to_term_in_query($query) {
    	global $pagenow;
    	$post_type = 'product'; // change to your post type
    	$taxonomy  = 'brand'; // change to your taxonomy
    	$q_vars    = &$query->query_vars;
    	if ( $pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $post_type && isset($q_vars[$taxonomy]) && is_numeric($q_vars[$taxonomy]) && $q_vars[$taxonomy] != 0 ) {
    		$term = get_term_by('id', $q_vars[$taxonomy], $taxonomy);
    		$q_vars[$taxonomy] = $term->slug;
    	}
    }
    function wc_customize_product_sorting($sorting_options){
        $sorting_options = array(
            'menu_order' => __( 'Sort by...', 'woocommerce' ),
            'popularity' => __( 'Sort by popularity', 'woocommerce' ),
            'rating'     => __( 'Sort by average rating', 'woocommerce' ),
            'date'       => __( 'Sort by latest', 'woocommerce' ),
            'price'      => __( 'Sort by price: low to high', 'woocommerce' ),
            'price-desc' => __( 'Sort by price: high to low', 'woocommerce' ),
        );
    
        return $sorting_options;
    }

    function cart_count_fragments( $fragments ) {
        $fragments['span.cart-items-count.count'] = '<span class="cart-items-count count">' . WC()->cart->get_cart_contents_count() . '</span>';
        return $fragments;    
    }
    
    function comments_loadmore_handler(){
    	global $product;
    	
    	$id = $product->id;
    	$rpage=$_POST['rpage'];
    	$limit=$_POST['limit'];
        $offset = ($rpage * $limit) - $limit;
        $args = [
            'number'      => $limit,
            'offset'      => $offset ,
            'status'      => 'approve',
            'post_status' => 'publish',
            'post_type'   => 'product',
            'post_id' => $id
        ];
        $reviews = get_comments( $args );
        if ( $reviews) { ?>           
            <?php foreach ($reviews as $review) {
                $date = date('d F Y', strtotime($review->comment_date));
                $rating = intval( get_comment_meta( $review->comment_ID, 'rating', true ) );
                ?>
                <div class="custom-review-item">
                    <div class="row">
                        <div class="col-lg-3 primary-output">
                            <div class="name">   <?= $review->comment_author; ?></div>
                            <?php if ( $rating && wc_review_ratings_enabled() ) { ?>
                                <div class="rating">
                                    <?= wc_get_rating_html( $rating ); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-lg-6 comment-output"><?= $review->comment_content; ?></div>
                        <div class="col-lg-3 date-output"><?= $date; ?></div>
                    </div>
                </div>
            <?php } ?>
    <?php
        }else{
            ?><div class="custom-review-item custom-review-item--noreviews">No more reviews</div><?php
        }
    ?>
    <?php
    	die; // don't forget this thing if you don't want "0" to be displayed
    }
}