<?php
namespace Blue2\Scruffy\Controllers;

class ShopController{

    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'woocommerceHookAdjustments']);
    }

    private function registerFilters()
    {
        add_filter('woocommerce_pagination_args', 	[$this, 'alterWooPagination'] );
        add_filter('woocommerce_sale_flash', [$this, 'removeWooSaleBadge']);
        add_filter('woocommerce_account_menu_items', [$this, 'updateAccountMenu'], 999 );
    }

    public function woocommerceHookAdjustments()
    {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
    }

    public function alterWooPagination( $args ) {

        $args['prev_text'] = 'Previous';
        $args['next_text'] = 'Next';

        return $args;
    }

    function removeWooSaleBadge()
    {
        return false;
    }

    public function updateAccountMenu($items) {
        unset($items['downloads']);
        return $items;
    }

}
