<div class="custom-single-post">

    <div class="title-holder">
        <div class="date"><?= get_the_date('d.m.Y') ?></div>
        <h1><?php the_title(); ?></h1>
    </div>

    <div class="news-holder">
        <?php if(get_the_post_thumbnail_url()) { ?>
            <div class="outer-holder text-center">
                <div class="image-holder">
                    <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                </div>
            </div>
        <?php } ?>

        <div class="content-holder">
            <?php the_content(); ?>
        </div>
    </div>


    <?php
    $latestNewsArgs = [
        'post_type' => 'post',
        'post_status' => 'publish',
        'post__not_in' => [get_the_id()],
        'posts_per_page' => 3
    ];
    $latestNewsQuery = new WP_Query($latestNewsArgs);
    $companyLogo = get_field('company_logo', 'option');
    if($latestNewsQuery->have_posts()) { ?>
        <div class="latest-news news-output">
            <h2 class="text-center latest-news-title">Latest News</h2>
            <div class="row justify-content-center">
                <?php while($latestNewsQuery->have_posts()) {
                    $latestNewsQuery->the_post();
                    $image = get_the_post_thumbnail_url() ?: $companyLogo['url'];
                    $imageClass = get_the_post_thumbnail_url() ? 'set-image' : 'default-image';
                    ?>
                    <div class="news-col col-sm-6 col-xxl-3">
                        <div class="news-item">
                            <a href="<?php the_permalink(); ?>">
                                <div class="image-section <?= $imageClass; ?>">
                                    <img src="<?= $image; ?>" alt="<?php the_title(); ?>">
                                </div>
                                <div class="content-section">
                                    <div class="date"><?= get_the_date('d.m.Y') ?></div>
                                    <h2><?php the_title(); ?></h2>
                                    <div class="read-article">Read More <i class="far fa-arrow-right"></i></div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php } wp_reset_postdata(); ?>
            </div>
        </div>
    <?php } ?>
</div>
