<?php
$banner = get_field('banner_images');
$departmentsIntro = get_field('departments_intro');
?>
<main>
    <?php
    get_template_part('templates/parts/hero-banner');
    ?>
    <div class="content-container">
        <section class="departments-row row text-center justify-content-center">
            <div class="section__intro">
                <div class="col-12">
                    <?= $departmentsIntro; ?>
                </div>
            </div>
            <?php
            $args = [
                'parent' => 0,
                'hide_empty' => 0,
            ];
            $departments = get_terms(
                'brand',
                $args
            );
            if ($departments) {
                $i = 0;
                foreach ($departments as $department) {
                    $i++;
                    $departmentImage = get_field('brand_featured_image', 'brand_' . $department->term_id);
                    $size = 'large';
                    $departmentImageUrl = $departmentImage['sizes'][ $size ];
                    $departmentLogo = get_field('brand_logo_alt', 'brand_' . $department->term_id);
                    $maintenance = get_field('maintenance', 'brand_' . $department->term_id);
                    $link_overlay = get_field('link_overlay', 'brand_' . $department->term_id);


                    if ($maintenance) {
                        $departmentUrl = '';
                        $linkClasses = 'maintenance--on';
                    } else {
                        $departmentPageArgs = [
                            'meta_key' => '_wp_page_template',
                            'meta_value' => 'template-department.php',
                            'hierarchical' => 0,
                            'post_status' => 'publish'
                        ];
                        $departmentPages = get_pages($departmentPageArgs);
                        $departmentPageIDs = [];
                        foreach ($departmentPages as $departmentPage) {
                            array_push($departmentPageIDs, get_field('brand', $departmentPage->post_id)->term_id);
                        }
                        $departmentIndex = array_search($department->term_id, $departmentPageIDs);
                        $linkClasses = 'preventDefault';
                        if ($departmentIndex !== FALSE) {
                            $departmentUrl = get_permalink($departmentPages[$departmentIndex]->post_id);
                        } else {
                            $departmentUrl = get_category_link($brand->term_id);
                        }
                        //$departmentUrl = esc_url(home_url('/brand/'.$department->slug));
                        $linkClasses = '';
                    }
                    if (!$departmentLogo) {
                        // Get fallback in case alt brand logo is not set.
                        $departmentLogo = get_field('brand_logo', 'brand_' . $department->term_id);
                    }
                    $size = 'medium';
                    $departmentLogoUrl = $departmentLogo['sizes'][ $size ];
                    ?>
                    <div class="department__panel cat-col col-6">
                        <div class="cat-panel">
                            <a class="<?= $linkClasses; ?>" href="<?= $departmentUrl; ?>">
                                <div class="department-logo-wrapper<?php if ($maintenance) {
                                    echo ' panel-overlay-bg';
                                }; ?>">


                                    <div class="department__image img-wrapper row-tint">
                                        <?php if ($departmentImage) { ?>
                                            <img class="department__bg" src="<?= $departmentImageUrl; ?>" alt="" ;>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                    <?php
                                    if ($departmentLogo) {
                                        ?>
                                        <img class="department__logo" src="<?= $departmentLogoUrl; ?>"
                                             alt="<?= $department->name; ?>">
                                        <?php
                                    }
                                    ?>
                                    <?php
                                    if ($maintenance) {
                                        echo '<p>' . $link_overlay . '</p>';
                                    }
                                    ?>
                                </div>
                                <h2><?= $department->name; ?></h2>
                                <p><?= $department->descpription; ?></p>
                            </a>
                        </div>
                    </div>
                    <?php
                }
            }
            ?>
            <div class="col-12">
                <a class="btn btn-primary" href="/shop/">Explore all products</a>
            </div>
        </section>
    </div>
    <?php
    get_template_part('templates/parts/feature-row');
    ?>

    <?php
    //start transient

    $homepageBrandTransient = get_transient('homepageBrands');

    if (!$homepageBrandTransient) {

        ob_start();
        $featuredBrands = get_field('featured_brands');
        $subBrandArgs = [
            'meta_key' => '_wp_page_template',
            'meta_value' => 'template-brand.php',
            'hierarchical' => 0,
            'post_status' => 'publish'
        ];
        $subBrandPages = get_pages($subBrandArgs);
        $brandPageTermIDs = [];
        foreach ($subBrandPages as $subBrandPage) {
            array_push($brandPageTermIDs, get_field('brand', $subBrandPage->post_id)->term_id);
        }
        if ($featuredBrands) { ?>
            <section class="brands-carousel content-container text-center">
                <h2>Brands to explore</h2>
                <div class="swiper-carousel">
                    <div class="swiper-wrapper">
                        <?php foreach ($featuredBrands as $brand) {
                            $brandObject = get_term_by('id', $brand, 'brand');
                            $brandParent = ($brandObject->parent == 0) ? $brandObject : get_term($brandObject->parent, 'brand');
                            $brandIndex = array_search($brandObject->term_id, $brandPageTermIDs);
                            if ($brandIndex !== FALSE) {
                                $subBrandPages[$brandIndex];
                                $brandLink = get_permalink($subBrandPages[$brandIndex]->post_id);
                            } else {
                                $brandLink = get_category_link($brand);
                            }
                            $image = get_field('brand_featured_image', 'brand_' . $brand) ?: get_field('brand_featured_image', 'brand_' . $brandParent->term_id);
                            $size = 'medium';
                            $thumb = $image['sizes'][ $size ];
                            ?>
                            <div class="swiper-slide">
                                <a href="<?= $brandLink; ?>">
                                    <div class="img-wrapper img-round">
                                        <img class="img-fluid" src="<?php echo esc_url($thumb); ?>"
                                             alt="<?= $image['title']; ?>">
                                    </div>
                                    <p><?= $brandObject->name; ?></p>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="swiper-pagination swiper-pagination--desktop"></div>
                </div>
                <div class="swiper-button-prev swiper-button-prev--desktop"></div>
                <div class="swiper-button-next swiper-button-next--desktop"></div>
            </section>
            <section class="brands-carousel--mobile content-container text-center">
                <?php if ($featuredBrands){
                $i = 0;
                ?>
                <h2>Brands to explore</h2>
                <div class="swiper-carousel">
                    <div class="swiper-wrapper">

                        <?php foreach ($featuredBrands

                        as $brand):
                        $i++;
                        $brandObject = get_term_by('id', $brand, 'brand');
                        $brandParent = ($brandObject->parent == 0) ? $brandObject : get_term($brandObject->parent, 'brand');
                        $brandIndex = array_search($brandObject->term_id, $brandPageTermIDs);
                        if ($brandIndex !== FALSE) {
                            $subBrandPages[$brandIndex];
                            $brandLink = get_permalink($subBrandPages[$brandIndex]->post_id);
                        } else {
                            $brandLink = "/brand/" . $subBrand->slug;
                        }
                        //$brandLink = get_category_link($brand);
                        $image = get_field('brand_featured_image', 'brand_' . $brand) ?: get_field('brand_featured_image', 'brand_' . $brandParent->term_id);
                        if ($i == 1){
                        //$mobSlideClass=' swiper-slide--mobile';
                        ?>
                        <div class="swiper-slide swiper-slide--brands-mobile">
                            <?php
                            } else {
                                // $mobSlideClass='';
                            }
                            ?>
                            <div class="slide-inner">
                                <a href="<?= $brandLink; ?>">
                                    <div class="img-wrapper img-round">
                                        <img class="img-fluid" src="<?= $image['url']; ?>"
                                             alt="<?= $image['title']; ?>">
                                    </div>
                                    <p><?= $brandObject->name; ?></p>
                                </a>
                            </div>

                            <?php
                            if ($i > 5) {
                                $i = 0;
                                // close swiper slide
                                echo '</div>';
                            }
                            ?>
                            <?php endforeach;
                            if ($i > 0 && $i < 6) {
                                // Still need to close the slide.
                                echo '</div>';
                            }
                            ?>
                        </div>
                        <div class="swiper-pagination swiper-pagination--mobile"></div>
                    </div>
                    <div class="swiper-button-prev swiper-button-prev--mobile"></div>
                    <div class="swiper-button-next swiper-button-next--mobile"></div>
                    <?php } ?>
            </section>
        <?php }
        $homepageBrands = ob_get_clean();
        set_transient('homepageBrands', $homepageBrands, 1 * DAY_IN_SECONDS);
        echo $homepageBrands;
    } else {
        echo $homepageBrandTransient;
    }
    //end transient

    ?>

    <?php
    get_template_part('templates/parts/membership-cta');
    ?>

    <?php
    $instaFeed = get_field('instagram_shortcode', 'option');
    if ($instaFeed) {
        $instaTitle = get_field('instagram_title', 'option');
        $instaDesc = get_field('instagram_description', 'option'); ?>
        <section class="custom-insta-feed content-container">
            <?php if ($instaTitle) { ?><h2><a href="https://www.instagram.com/casa.world/"
                                              target="_blank"><?= $instaTitle; ?></a></h2><?php } ?>
            <?php if ($instaDesc) {
                echo $instaDesc;
            } ?>
            <?= get_field('instagram_shortcode', 'option'); ?>
        </section>
    <?php } ?>
</main>
