<?php
namespace Blue2\Scruffy\Controllers;

use Blue2\Scruffy\Site;

class FavouriteController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'favouriteRewrite']);
        add_action('wp_head', [$this, 'loadGlobalVar']);
        add_action('wp_ajax_setFavouriteProduct', [$this, 'setFavouriteAjaxHandler']);
        add_action('wp_ajax_nopriv_setFavouriteProduct', [$this, 'setFavouriteAjaxHandler']);
        add_action('woocommerce_account_favourites_endpoint', [$this, 'displayFavouritesTab']);
    }

    private function registerFilters()
    {
        add_filter('woocommerce_account_menu_items', [$this, 'addFavouritesToAccountMenu'], 99, 1);
    }

    public function favouriteRewrite()
    {
        add_rewrite_endpoint('favourites', EP_ROOT | EP_PAGES);
    }

    public static function loadGlobalVar()
    {
        global $wp_query; ?>
        <script type="text/javascript">
            const ajaxurl = <?= json_encode(admin_url("admin-ajax.php")); ?>;
            const ajaxnonce = <?= json_encode(wp_create_nonce("itr_ajax_nonce")); ?>;
        </script><?php
    }

    public function setFavouriteAjaxHandler()
    {
        if ((isset($_POST['product']) && $_POST['product'] != '')) {
            $currentUser = get_current_user_id();
            $productID = $_POST['product'];
            $userID = $currentUser;
            if ($userID) {
                $favourites = get_field('favourite_products', 'user_' . $userID);
                if (!$favourites) {
                    $favourites = [$productID];
                } else {
                    if (!in_array($productID, $favourites)) {
                        $favourites[] = $productID;
                    } else {
                        $favourites = array_diff($favourites, [$productID]);
                    }
                }

                update_field('favourite_products', $favourites, 'user_' . $userID);

                echo 'OK';
            }
        }
        die;
    }



    public function displayFavouritesTab()
    {
        get_template_part('templates/sections/favourites-display');
    }

    public function addFavouritesToAccountMenu($items)
    {
        $newMenuItems = [
            'favourites' => __('Favourites', 'custom_woocommerce'),
        ];
        $newMenuItems = array_slice($items, 0, 4, true) + $newMenuItems + array_slice($items, 1, count($items), true);
        return $newMenuItems;
    }

}
