import React, { useEffect, useState } from 'react';
import { NavLink, withRouter } from 'react-router-dom';
import Routes from '../routes';
import Logo from '../images/logo.png';
import { GET_BANNER_URL } from './../config/endpoints';
import axios from 'axios';

const Header = ({ location }) => {
    const [bannerUrl, setBannerUrl] = useState("");
    const showText =
        location.pathname === '/booking/choose-journey' || location.pathname === '/booking/';

    useEffect(() => {
        getBanner();
    });
    async function getBanner(){
        const response = await axios.get(GET_BANNER_URL, {});
        if(response){
            if (response.status !== 200) {
                console.warn(response);
                return;
            }
            setBannerUrl(response.data);
        };
    }
    return (
        <>
            <img src={Logo} alt="Xplore Dundee Logo" className="logo" />            
            <div className="header">
                <ul>
                    {Routes.map((route, index) => {
                        return route.hide ? null : (
                            <li key={index}>
                                <NavLink
                                    exact={true}
                                    isActive={route.isActive && route.isActive}
                                    to={route.path}
                                    title={route.title}
                                    onClick={e => e.preventDefault()}>
                                    {route.title}
                                </NavLink>
                            </li>
                        );
                    })}
                </ul>
            </div>
            {bannerUrl && bannerUrl != "" && (<img src={bannerUrl} alt="Xplore Dundee Banner" className="banner" />)}
            <div>{showText && <p>You can book your tickets for the Airport Xpress below. </p>}</div>            
        </>
    );
};



export default withRouter(Header);
