import React, { Component } from 'react';
import axios from 'axios';
import { ALL_TICKETS } from '../config/endpoints';
import { connect } from 'react-redux';
import { addTickets, setRoute, removeJourneys } from '../redux/actions';
import { base } from '../routes';
import {
    JourneyTypeSelect,
    DirectionSelect,
    DateSelect,
    TicketList
} from '../components/ChooseTickets';

class ChooseTicket extends Component {
    constructor(props) {
        super(props);

        this.now = new Date();
    }

    componentDidMount() {
        const urlParams = new URLSearchParams(this.props.location.search);
        if (urlParams.get('complete') !== null) {
            this.props.setRoute(6);
            const updated = urlParams.get('updated')!==null ? urlParams.get('updated') : null;
            console.log(updated);
            if (updated === '1'){
                console.log('this is working');
                this.props.history.push(`${base}/complete/${urlParams.get('complete')}/1`);
            }else{
                this.props.history.push(`${base}/complete/${urlParams.get('complete')}`);
            }
        } else {
            this.props.setRoute(1);
        }

        this.props.removeJourneys();
        axios
            .get(ALL_TICKETS)
            .then(response => {
                this.props.addTickets(JSON.parse(response.data));
                this.setState({ loading: false });
            })
            .catch(error => {
                console.warn('CATCH ERROR: ', error);
            });
    }

    render() {
        const sessionExpired = typeof this.props.history.location.state !== 'undefined' && this.props.history.location.state.sessionExpired;
        return (
            <div className="choose-ticket">
                <h1>Choose Journey</h1>
                {sessionExpired && (<div className='alertExpire'>Your session is expired. Please try again.</div>)}
                <div className="content">
                    <JourneyTypeSelect />
                    <DirectionSelect />
                    <DateSelect />
                    <TicketList />
                </div>
            </div>
        );
    }
}

export default connect(
    null,
    { addTickets, setRoute, removeJourneys }
)(ChooseTicket);
