// global params

import React, { useEffect, useState, useRef } from 'react';
import { useHistory } from 'react-router';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { connect } from 'react-redux';
import { toast } from 'react-toastify';
import { ADD_NEW_BOOKING, CHECK_BOOKING, CHECK_LOGIN, SET_NOTES } from './../config/endpoints';
import { addBooking, setRoute } from '../redux/actions';
import { getTotalSeatsFromCart, getTotalCostFromCart } from '../redux/selectors';
import { base } from '../routes';

const Payment = ({
    user,
    outboundJourney,
    inboundJourney,
    inCart,
    addons,
    seats,
    price,
    setRoute,
    addBooking
}) => {
    const { firstName, surname, email, phoneNumber } = user;
    const [redirect, setRedirect] = useState(false);
    const [agent, setAgent] = useState(null);
    const [bookingId, setBookingId] = useState(null);
    const [notes, setNotes] = useState(null);
    const formRef = useRef();
    const history = useHistory();

    useEffect(() => {
        if (bookingId !== null && agent === false) {
            redirectWorldPay();
        }
    }, [bookingId, agent]);

    useEffect(() => {
        setRoute(5);
        checkLogin();
        addBookingId();
    }, []);

    const checkLogin = () => {
        axios.post(CHECK_LOGIN).then(response => {
            console.log(response);
            if (response.data === true) {
                setAgent(true);
            } else {
                setAgent(false);
            }
        });
    };

    const addBookingId = () => {
        const outbound = outboundJourney !== null ? outboundJourney.slug : false;
        const inbound = inboundJourney !== null ? inboundJourney.slug : false;

        axios
            .post(ADD_NEW_BOOKING, {
                firstName,
                surname,
                email,
                phoneNumber,
                outbound,
                inbound,
                addons,
                seats,
                inCart,
                price
            })
            .then(response => {
                const bookingIdResponse = response.data;
                addBooking(bookingIdResponse);
                setRedirect(true);
                setBookingId(bookingIdResponse);
            })
            .catch(error => {
                toast.error(error.response.data);
                console.error('Create booking:', error);
            });
    };

    const redirectWorldPay = () => {
        const form = formRef.current;
        form.submit();
    };

    async function checkBooking() {
        try{
            const bookCheck = await axios.post(CHECK_BOOKING, {
                bookingId
            }).then(function(data){
                if(data.data === 'success'){
                    skipPayment();
                } else {
                    history.push(`${base}`);
                }
            });
        } catch(err){
            console.error(err)
        }
    }

    async function skipPayment() {
        try {
            const response = await axios.post(SET_NOTES, {
                notes,
                bookingId
            });
            history.push(`${base}/complete/${bookingId}`);
        } catch (err) {
            console.error(err);
        }
    }

    const proceedToPayment = () => {
        if (window.confirm('Are you sure you want to leave, you cannot return to this stage?')) {
            redirectWorldPay();
        }
    };

    return (
        <div className="choose-journey">
            <h1>Payment</h1>
            {/* {agent === null && <Loader type="Oval" width={50} height={50} color="#088584" />} */}

            {bookingId !== null ? (
                <>
                    <form
                        action="https://secure.worldpay.com/wcc/purchase"
                        method="POST"
                        ref={formRef}>
                        <input type="hidden" name="instId" value="1357697" />
                        <input type="hidden" name="cartId" value={bookingId} />
                        <input type="hidden" name="amount" value={price} />
                        <input type="hidden" name="currency" value="GBP" />
                    </form>
                    {agent === true && (
                        <>
                            <textarea
                                name="notes"
                                id="notes"
                                cols="30"
                                rows="10"
                                onChange={e => setNotes(e.target.value)}
                                placeholder="Please enter any notes for this order"
                            />
                            <button
                                className="primary continue-button invalid"
                                onClick={() => checkBooking() }>
                                Skip Payment Gateway
                            </button>
                            <button
                                className="primary continue-button invalid"
                                onClick={() => proceedToPayment()}>
                                Proceed to payment
                            </button>
                        </>
                    )}
                </>
            ) : (
                <Loader type="Oval" width={50} height={50} color="#088584" />
            )}
        </div>
    );
};

const mapStateToProps = state => {
    const { outbound, inbound, addons, inCart } = state.cart;
    const seats = getTotalSeatsFromCart(state);
    const price = getTotalCostFromCart(state);

    return {
        bookingId: state.booking.bookingId,
        user: state.user,
        outboundJourney: outbound,
        inboundJourney: inbound,
        addons,
        seats,
        inCart,
        price
    };
};

export default connect(mapStateToProps, { addBooking, setRoute })(Payment);
