import { PROGRESS_ROUTE, PREVIOUS_ROUTE, SET_ROUTE } from '../actionTypes';
import { Routes } from './../../routes/index';

const initialState = {
    step: 1,
    continueDisable: false
};

export default function(state = initialState, action) {
    switch (action.type) {
        case PROGRESS_ROUTE: {
            const nextStep = state.step + 1;
            if (nextStep > Routes.length) return { ...state };
            const continueDisable = nextStep === Routes.length;
            return {
                ...state,
                continueDisable,
                step: nextStep
            };
        }
        case PREVIOUS_ROUTE: {
            const prevStep = state.step - 1;
            if (prevStep < 0) return { ...state };
            const continueDisable = prevStep === Routes.length;
            return {
                ...state,
                continueDisable,
                step: prevStep
            };
        }
        case SET_ROUTE: {
            const step = action.payload;
            return {
                ...state,
                step: step
            };
        }

        default:
            return state;
    }
}
