<?php

namespace XploreBooking\Controller;

class JourneyController
{

    

    public function __construct()
    {
        $this->registerActions();
        $this->seats = get_field('default_number_of_seats', 'options');
    }

    private function registerActions()
    {
        add_action('rest_api_init', function () {
            register_rest_route('xplore-booking/v1', '/get-all-journey-times/', [
                'methods' => 'GET',
                'callback' => [$this, 'getAllJourneyTimes'],
            ]);

            register_rest_route('xplore-booking/v1', '/return-available-journeys/', [
                'methods' => 'GET',
                'callback' => [$this, 'returnAvailableJourneys'],
            ]);
        });

        add_action('wp_dashboard_setup', [$this, 'generateJourneysWidget']);
        add_action('wp_dashboard_setup', [$this, 'restoreFailedBookingSeatsWidget']);
        add_action('init', function() {
            if(isset($_POST['gen'])) {
                $this->generateJourneyDates();
            }
        }, 12);
        add_action('init', function() {
            if(isset($_POST['restoreS'])) {
                $this->restoreFailedBookingSeats();
            }            
        }, 12);

        add_action('wp_dashboard_setup', [$this, 'downloadLastReportFile'], 12);
        

        add_action('post_submitbox_misc_actions', [$this, 'custom_button']);
        //add_filter('post_row_actions', 'modify_list_row_actions', 10 , 2);
    }

    public function downloadLastReportFile(){
        if(isset($_POST['restoreSFile'])){
            $filename = "restored_seats_report.csv";
            $filenameTemp = __DIR__ . '/../csv/restored_seats_report_temp.csv';
            $filepath = __DIR__ . '/../csv/restored_seats_report.csv';
            $fileAlreadyExist = $this->checkIfFileExistIntoMediaFolder("restored_seats_report");
            if($fileAlreadyExist){
                wp_delete_attachment($fileAlreadyExist->ID, true);
            }
            file_put_contents($filenameTemp, file_get_contents($filepath));
            define('ALLOW_UNFILTERED_UPLOADS', true);
            $res = media_handle_sideload([
                'name' => $filename,
                'type' => 'text/csv',
                'tmp_name' => $filenameTemp,
                'error' => 0,
                'size' => filesize($filenameTemp)
            ]);
            
            wp_redirect(wp_get_attachment_url($res));
            die;
        }
    }
    public function checkIfFileExistIntoMediaFolder($filename){
        $args           = [
            'posts_per_page' => 1,
            'post_type'      => 'attachment',
            'name'           =>  $filename,
        ];
        $get_attachment = new \WP_Query( $args );
        if ( ! $get_attachment || ! isset( $get_attachment->posts, $get_attachment->posts[0] ) ) {
            return false;
        }
        return $get_attachment->posts[0];
    }
    public function generateJourneysWidget() {
        wp_add_dashboard_widget('generate_journey', 'Generate Journeys', function(){
            $data = '
                <form method="POST" id="journeyGenerate" name="journeyGenerate">
                    <input type="hidden" name="gen" value="true">
                    <input type="submit" value="Generate Journey">
                </form>
            ';

            echo $data;
        });
    }

    public function restoreFailedBookingSeatsWidget() {
        wp_add_dashboard_widget('restore_failed_booking_seats', 'Restore Journeys Available Seats', function(){
            $data = '
                <p>This panel restores the available seats on the journeys starting from today.<br /><br />Note: The time to restore the seats available depends from the number of the journeys and can take several minutes, so once the restart button is clicked you <strong>MUST</strong> not close the window until the process finish.</p>
                <form method="POST" id="restoreSeats" name="restoreSeats">
                    <input type="hidden" name="restoreS" value="true">
                    <input type="submit" value="Restore Seats">
                </form>
                <br />
                <p>The button below allow you to download the report created on the last restoring process.</p>
                <form method="POST" id="restoreSeatsF" name="restoreSeatsF">
                    <input type="hidden" name="restoreSFile" value="true">
                    <input type="submit" value="Download report">
                </form>
            ';

            echo $data;
        });
    }

    public function restoreFailedBookingSeats(){
        set_time_limit(0);
        $fp = fopen(plugin_dir_path(__FILE__)."../csv/restored_seats_report.csv", 'w+');
        fputcsv($fp, ["Journey name","Total Seats","Original available seats","Restored available seats", "Seats amended?"]);

        $queryDate = date('Ymd', time());
        $args = [
            'post_type' => 'journey-date',
            'posts_per_page' => -1,
            'numberposts' => -1,
            'meta_key' => 'date',
            'orderby'   => 'meta_value',
            'order' => 'ASC',
            'meta_query' => [
                [
                    'key' => 'date',
                    'compare' => '>=',
                    'value' => $queryDate,
                ],
            ],
        ];
        $journeys = get_posts($args);
        
        if($journeys){          
            echo "<a href='/wp/wp-admin/index.php'><button>Return to home</button></a>";  
            foreach($journeys as $journey){
                $totalSeats = get_field('total_seats', $journey->ID);
                $journeySeats = $totalSeats;
                $originalAvailableSeats= get_field('seats', $journey->ID);

                echo "<h3>".get_the_title($journey)."</h3><br />Total seats: {$totalSeats}<br />Original available seats: {$originalAvailableSeats}<br />";
                //Outbound bookings
                $bookingArgs = [
                    'post_type' => 'booking',
                    'post_per_page' => -1,
                    'numberposts' => -1,
                    'meta_query' => [                        
                        'relation'      => 'AND',
                        [
                            'key' => 'outbound_journey',
                            'compare' => 'LIKE',
                            'value' => '"'.$journey->ID.'"'
                        ],
                        [
                            'key' => 'booking_status',
                            'compare' => '=',
                            'value' => 'Completed',
                        ],
                    ]
                ];
                $outboundBookings = get_posts($bookingArgs);
                if($outboundBookings){
                    foreach($outboundBookings as $booking){
                        $seatsToRestore = get_field('total_seats', $booking);
                        $totalSeats -= $seatsToRestore;
                    }
                }
                // Inbound Bookings
                $bookingArgs = [
                    'post_type' => 'booking',
                    'post_per_page' => -1,
                    'numberposts' => -1,
                    'meta_query' => [
                        'relation'      => 'AND',
                        [
                            'key' => 'inbound_journey',
                            'compare' => 'LIKE',
                            'value' => '"'.$journey->ID.'"'
                        ],
                        [
                            'key' => 'booking_status',
                            'compare' => '=',
                            'value' => 'Completed',
                        ],
                    ]
                ];
                
                $inboundBookings = get_posts($bookingArgs);
                if($inboundBookings){
                    foreach($inboundBookings as $booking){
                        $seatsToRestore = get_field('total_seats', $booking);
                        $totalSeats -= $seatsToRestore;
                    }
                }
                echo "Restored seats: " . ($originalAvailableSeats == $totalSeats ? "": "<strong>" ) . "{$totalSeats}" . ($originalAvailableSeats == $totalSeats ? "": "</strong>" ) . "<br /><br />";
                fputcsv($fp,[
                    get_the_title($journey),
                    $journeySeats,
                    $originalAvailableSeats,
                    $totalSeats,
                    $originalAvailableSeats == $totalSeats ? "N" : "Y"
                ]);
            }
        }
        set_time_limit(120);

        fputcsv($fp, [""]);        
        fclose($fp);
        ob_flush();
        die;
    }

    public function generateJourneyDates() {
        $iterator = new \DateTime();
        $sixMonthsFuture = new \DateTime();
        $sixMonthsFuture->add(new \DateInterval('P6M'));

        $oneDayInterval = new \DateInterval('P1D');
        $journeys = $this->getJourneyTimes();

        while($iterator < $sixMonthsFuture) {
            foreach($journeys as $journey) {
                $newSlug = $journey['slug'] . '-' . $iterator->format('d-m-Y');
                BookingController::updateOrInsertPostJourney($newSlug, 0);
            }
            $iterator->add($oneDayInterval);
        }
    }

    public static function returnAvailableJourneys($request)
    {
        $departLocation = $request['depart'];
        $departureDate = $request['departFormatted'];
        $returnDate = $request['returnFormatted'];
        $journeyType = $request['journeyType'];
        $seats = $request['totalSeats'];

        if ($departLocation == 'DUNDEE') {
            $direction = 'dundee';
            $return = 'edinburgh';
        } else {
            $direction = 'edinburgh';
            $return = 'dundee';
        }

        /*** TODO ADD CHECK IF THERE ARE ENOUGH SEATS LEFT ***/
        $outboundDates['outbound'] = self::returnComparedDates($departureDate, $direction);

        if ($journeyType == 'RETURN') {
            $inboundDates['inbound'] = self::returnComparedDates($returnDate, $return);
            $allDates = array_merge($inboundDates, $outboundDates);
        } else {
            $allDates = $outboundDates;
        }
        return json_encode($allDates);

    }

    public static function returnComparedDates($date, $direction)
    {
        $queryDate = date('Ymd', strtotime($date));
        $args = [
            'post_type' => 'journey-date',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'meta_query' => [
                [
                    'key' => 'date',
                    'compare' => '=',
                    'value' => $queryDate,
                ],
            ],
        ];

        $journeys = get_posts($args);
        $departureDates = [];

        $expectedJourneys = self::returnAvailableTimes($date, $direction);
        if ($journeys) {
            foreach ($journeys as $journey) {
                $parentJourney = get_field('journey');
                if($parentJourney){
                    $publishedJourney = false;
                    foreach($parentJourney as $journeyPost){
                        $journeyStatus = get_post_status($journeyPost);
                        if($journeyStatus == 'publish'){
                            $publishedJourney = true;
                            break;
                        }
                    }
                    if(!$publishedJourney) continue;
                    
                    if (explode('-', $journey->post_name)[0] === $direction) {
                        $departureDates[$journey->post_name] = [
                            'seats' => get_field('seats', $journey->ID),
                        ];
                    }
                }
            };
        }

        $combinedJourneys = array_replace_recursive($expectedJourneys, $departureDates);
        return $combinedJourneys;

    }

    public static function returnAvailableTimes($departureDate, $direction)
    {
        $journeyData = [];

        $args = [
            'post_type' => 'journey',
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC',
            'posts_per_page' => -1,
        ];
        $journeys = new \WP_Query($args);

        while ($journeys->have_posts()) {
            $journeys->the_post();
            if (explode('-', get_post_field('post_name', get_post()))[0] === $direction) {
                $journeyData[get_post_field('post_name', get_post()) . '-' . $departureDate] = [
                    'id' => get_the_id(),
                    'title' => get_the_title(),
                    'departure_time' => get_field('departure_time'),
                    'arrival_time' => get_field('arrival_time'),
                    'surcharge' => get_field('surcharge'),
                    'seats' => get_field('seats'),
                ];
            }
        }

        return $journeyData;
    }

    public static function getAllJourneyTimes()
    {
        $journeyData = [];

        $args = [
            'post_type' => 'journey',
            'posts-per_page' => -1,
        ];
        $journeys = new \WP_Query($args);

        while ($journeys->have_posts()) {
            $journeys->the_post();
            $journeyData[] = [
                'id' => get_the_id(),
                'title' => get_the_title(),
                'slug' => get_post_field('post_name', get_post()),
                'departure_time' => get_field('departure_time'),
                'arrival_time' => get_field('arrival_time'),
                'surcharge' => get_field('surcharge'),
            ];
        }

        return json_encode($journeyData);
    }

    public function getJourneyTimes(){
        $journeyData = [];

        $args = [
            'post_type' => 'journey',
            'posts-per_page' => -1,
        ];
        $journeys = new \WP_Query($args);

        while ($journeys->have_posts()) {
            $journeys->the_post();
            $journeyData[] = [
                'id' => get_the_id(),
                'title' => get_the_title(),
                'slug' => get_post_field('post_name', get_post()),
                'departure_time' => get_field('departure_time'),
                'arrival_time' => get_field('arrival_time'),
                'surcharge' => get_field('surcharge'),
            ];
        }

        return $journeyData;
    }

    public function dummyJourneyTimes()
    {

        /*** TIMES FROM DUNDEE ***/
        $outwardJourneys = [
            'dundee-to-edinburgh-0230' => [
                'post_title' => 'Dundee to Edinburgh 02:30',
                'departure_time' => '02:30',
                'arrival_time' => '03:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-0400' => [
                'post_title' => 'Dundee to Edinburgh 04:00',
                'departure_time' => '04:00',
                'arrival_time' => '05:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-0530' => [
                'post_title' => 'Dundee to Edinburgh 05:30',
                'departure_time' => '05:30',
                'arrival_time' => '06:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-0700' => [
                'post_title' => 'Dundee to Edinburgh 07:00',
                'departure_time' => '07:00',
                'arrival_time' => '08:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-0830' => [
                'post_title' => 'Dundee to Edinburgh 08:30',
                'departure_time' => '08:30',
                'arrival_time' => '09:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1000' => [
                'post_title' => 'Dundee to Edinburgh 10:00',
                'departure_time' => '10:00',
                'arrival_time' => '11:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1130' => [
                'post_title' => 'Dundee to Edinburgh 11:30',
                'departure_time' => '11:30',
                'arrival_time' => '12:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1300' => [
                'post_title' => 'Dundee to Edinburgh 13:00',
                'departure_time' => '13:00',
                'arrival_time' => '14:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1430' => [
                'post_title' => 'Dundee to Edinburgh 14:00',
                'departure_time' => '14:30',
                'arrival_time' => '15:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1600' => [
                'post_title' => 'Dundee to Edinburgh 16:00',
                'departure_time' => '16:00',
                'arrival_time' => '17:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1730' => [
                'post_title' => 'Dundee to Edinburgh 17:30',
                'departure_time' => '17:30',
                'arrival_time' => '18:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-1900' => [
                'post_title' => 'Dundee to Edinburgh 19:00',
                'departure_time' => '19:00',
                'arrival_time' => '20:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-2030' => [
                'post_title' => 'Dundee to Edinburgh 20:30',
                'departure_time' => '20:30',
                'arrival_time' => '21:50',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-2200' => [
                'post_title' => 'Dundee to Edinburgh 22:00',
                'departure_time' => '22:00',
                'arrival_time' => '23:20',
                'seats' => $this->seats,
            ],
            'dundee-to-edinburgh-2300' => [
                'post_title' => 'Dundee to Edinburgh 23:30',
                'departure_time' => '23:30',
                'arrival_time' => '00:50',
                'seats' => $this->seats,
            ],
        ];

        /*** TIMES TO DUNDEE ***/
        $inwardJourneys = [
            'edinburgh-to-dundee-0100' => [
                'post_title' => 'Edinburgh to Dundee 01:00',
                'departure_time' => '01:00',
                'arrival_time' => '02:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-0400' => [
                'post_title' => 'Edinburgh to Dundee 04:00',
                'departure_time' => '04:00',
                'arrival_time' => '05:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-0530' => [
                'post_title' => 'Edinburgh to Dundee 05:30',
                'departure_time' => '05:30',
                'arrival_time' => '06:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-0700' => [
                'post_title' => 'Edinburgh to Dundee 07:00',
                'departure_time' => '07:00',
                'arrival_time' => '08:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-0830' => [
                'post_title' => 'Edinburgh to Dundee 08:30',
                'departure_time' => '08:30',
                'arrival_time' => '09:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1000' => [
                'post_title' => 'Edinburgh to Dundee 10:00',
                'departure_time' => '10:00',
                'arrival_time' => '11:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1130' => [
                'post_title' => 'Edinburgh to Dundee 11:30',
                'departure_time' => '11:30',
                'arrival_time' => '12:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1300' => [
                'post_title' => 'Edinburgh to Dundee 13:00',
                'departure_time' => '13:00',
                'arrival_time' => '14:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1430' => [
                'post_title' => 'Edinburgh to Dundee 14:00',
                'departure_time' => '14:30',
                'arrival_time' => '15:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1600' => [
                'post_title' => 'Edinburgh to Dundee 16:00',
                'departure_time' => '16:00',
                'arrival_time' => '17:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1730' => [
                'post_title' => 'Edinburgh to Dundee 17:30',
                'departure_time' => '17:30',
                'arrival_time' => '18:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-1900' => [
                'post_title' => 'Edinburgh to Dundee 19:00',
                'departure_time' => '19:00',
                'arrival_time' => '20:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-2030' => [
                'post_title' => 'Edinburgh to Dundee 20:30',
                'departure_time' => '20:30',
                'arrival_time' => '21:50',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-2200' => [
                'post_title' => 'Edinburgh to Dundee 22:00',
                'departure_time' => '22:00',
                'arrival_time' => '23:20',
                'seats' => $this->seats,
            ],
            'edinburgh-to-dundee-2300' => [
                'post_title' => 'Edinburgh to Dundee 23:30',
                'departure_time' => '23:30',
                'arrival_time' => '00:50',
                'seats' => $this->seats,
            ],
        ];

        return array_merge($outwardJourneys, $inwardJourneys);
    }

    function custom_button($post){
        if ($post->post_type !== 'journey-date') {
            return;
        }

        $postTitle = $post->post_title;
        $postID = get_the_ID();

        $postTitle = preg_replace('/\s+/', '+', $postTitle);

        $html = '<div id="major-publishing-actions" style="overflow:hidden">';
        $html .= '<div id="publishing-action">';
        $html .= '<a href="/wp/wp-admin/edit.php?post_type=booking&customFilter=1&journeyID='.$postID.'" class="button-primary" id="custom" target="_blank">Show all passengers</a>';
        $html .= '</div>';
        $html .= '</div>';

        echo $html;
    }
}
