import React, { useEffect, useState } from 'react';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { GET_CONFIRMATION_TEXT } from '../config/endpoints';
import { setRoute } from '../redux/actions';
import { connect } from 'react-redux';

const Confirmation = ({ match, setRoute, bookingId }) => {
    const [confirmations, setConfirmations] = useState([]);
    const updated = match.params.updated === '1';
    // const bookingId = match.params.bookingId;

    async function fetchData() {
        if (bookingId === null) return null;
        try {
            const response = await axios.get(GET_CONFIRMATION_TEXT, {
                params: {
                    bookingId
                }
            });
            setConfirmations(response.data);
        } catch (err) {
            console.warn(err);
        }
    }

    useEffect(() => {
        fetchData();
        setRoute(6);
    }, [bookingId]);

    return (
        <div className="centered-container">
            <img src="/content/plugins/xplore-booking-plugin/dist/images/logo.png" />
            {updated ? (
                <h1 style={{ height: `auto` }}>Booking Amended Successfully!</h1>
            ) : (
                <h1 style={{ height: `auto` }}>
                    Thank you for booking the Edinburgh Airport Express with Xplore More
                </h1>
            )}
            <div className="confirmation" style={{ textAlign: 'left' }}>
                {confirmations.length === 0 ? (
                    <div className="loadingSpinnerContainer">
                        <Loader type="Oval" width={50} height={50} color="#088584" />
                    </div>
                ) : (
                    confirmations.map((confirmation, key) => {
                        return (
                            <p
                                key={key}
                                style={{ fontWeight: 600 }}
                                dangerouslySetInnerHTML={{ __html: confirmation }}
                            />
                        );
                    })
                )}
                <p>
                    <strong>Your Ticket Confirmation is being sent to your email address</strong>
                </p>
            </div>
            <br />
            <p>We hope you have an enjoyable journey to/from Edinburgh Airport. Our X90 coach arrives and 
            departs from Union Street, Dundee (opposite the Malmaison Hotel) and from Stance E outside the 
            main terminal building at Edinburgh Airport.</p>
            <p>
            Please check your entire booking carefully and if you have any queries or questions regarding 
            any of these details please call 01382 221609 or email myxplore@mcgillsbuses.co.uk as soon as 
            possible. Phone lines are open Monday to Friday 1000 – 1700 and Saturday 1000 – 1400. 
            </p>
            <p>
                <strong>
                Please ensure that you arrive at the coach stance 
                <u>at least 10 minutes prior</u> to the time
                of your departure as <u>after this time your seat may be released to other customers</u>.
                </strong>
            </p>

            <p>
                <strong>Scottish Concessionary Card Holders and Students</strong> <br />
                <strong>All Scottish Concessionary Card Holders</strong> must present their cards to the driver on boarding 
                the Coach.   Cards will be scanned on the ticket machine and the relevant concessionary ticket/s 
                issued.   Please Note:  If Concessionary Card/s are not available for presentation to the driver, 
                your booking will be invalid and you will be required to pay the relevant standard fare for the 
                journey with no refunds available on production of concession cards at a later date. 
            </p>
            <p>
                <strong>Students</strong>
                <br />
                All students must show a current and valid matriculation card (or letter of acceptance) to the 
                driver prior to boarding the coach.   If you do not have a Student Card/Letter of Acceptance your 
                booking will be invalid and you will be required to pay the relevant standard fare for your journey
                with no refunds available on production of a student matriculation card at a later date.
            </p>
            <p>
                <strong>Luggage Allowance</strong>
                <br/>
                Details of your baggage allowance can be found on your Final Confirmation</p>
            <p>
                Terms and Conditions can be found on the
                <a href="//www.xploremore.co.uk/">xploremore.co.uk</a> website or by contacting our Travel 
                Centre in Commercial Street.
            </p>
            <p>
                <strong>Booking Queries/Service Information</strong>
                <br/>
                Booking queries: 
                <ul>
                    <li>Telephone: 01382 221609 <br/>
                    Monday to Friday 1000 - 1700  Saturday 1000 - 1400</li>
                </ul>
            </p>
            <p>
            For information relating to service delivery outwith the above hours: 07845 785068
            </p>
            <br />
            <a
                href="//www.xploremore.co.uk/"
                title="National Express Xplore Dundee"
                className="primary">
                Back to Xplore More Site
            </a>
            <button
                title="Print this page"
                className="primary"
                onClick={() => window.print()}
                style={{ marginLeft: `25px` }}>
                Print
            </button>
        </div>
    );
};

const mapStateToProps = state => {
    const bookingId = state.booking.bookingId;

    return {
        bookingId
    };
};

export default connect(mapStateToProps, { setRoute })(Confirmation);
