import AddOns from './AddOns';
import ChooseTicket from './ChooseTicket';
import ChooseJourney from './ChooseJourney';
import Confirmation from './Confirmation';
import Payment from './Payment';
import YourDetails from './YourDetails';

export const base = '/booking';

export const Routes = [
    {
        path: `${base}`,
        component: ChooseTicket,
        title: 'Choose Journey',
        isActive: (match, location) => {
            return (
                location.pathname === `${base}` ||
                location.pathname === `${base}/` ||
                location.pathname === `${base}/choose-journey`
            );
        }
    },
    {
        path: `${base}/choose-journey`,
        component: ChooseJourney,
        title: 'Choose Journey',
        hide: true
    },
    {
        path: `${base}/add-ons`,
        component: AddOns,
        title: 'Add Ons'
    },
    {
        path: `${base}/your-details`,
        component: YourDetails,
        title: 'Your Details'
    },
    {
        path: `${base}/payment`,
        component: Payment,
        title: 'Payment'
    },
    {
        path: `${base}/complete/:bookingId/:updated`,
        component: Confirmation,
        title: 'Confirmation',
        hide: true
    },
    {
        path: `${base}/complete/:bookingId`,
        component: Confirmation,
        title: 'Confirmation'
    }
];

export default Routes;
