<?php

namespace XploreBooking\Post;

class BasePost {

    private $_post = null;

    /**
     * BasePost constructor.
     * @param \WP_Post|null $post
     */
    public function __construct($post = null) {
        $this->_post = $post;
    }

    /**
     * @return \WP_Post
     */
    public function getPost() {
        return $this->_post;
    }

    /**
     * @param \WP_Post $post
     * @return mixed
     */
    protected function setPost($post) {
        return $this->_post = $post;
    }

    /**
     * @param int|\WP_Post $postID
     * @return bool
     */
    public function load($postID) {
        $post = get_post($postID);
        if ($post instanceof \WP_POST) {
            $this->_post = $post;
            return true;
        }
        return false;
    }

    /**
     * @param string $key
     * @param bool $format
     * @return mixed
     */
    public function get($key, $format = true) {
        return get_field($key, $this->getPost()->ID, $format);
    }

    /**
     * @param string $key
     * @param mixed $value
     * @return mixed
     */
    public function set($key, $value){
        return update_field($key, $value, $this->getPost()->ID);
    }
}