import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { GET_CONFIRMATION_TEXT } from '../config/endpoints';
import { setRoute } from '../redux/actions';
import { connect } from 'react-redux';

const Confirmation = ({ match, setRoute }) => {
    const [confirmations, setConfirmations] = useState([]);
    const updated = match.params.updated === '1';

    setRoute(6);
    async function fetchData() {
        const bookingId = match.params.bookingId;

        if (bookingId === null) return null;
        axios
            .get(GET_CONFIRMATION_TEXT, {
                params: {
                    bookingId
                }
            })
            .then(response => {
                setConfirmations(response.data);
            })
            .catch(err => console.warn(err));
    }

    useEffect(() => {
        fetchData();
    }, []);

    return (
        <div className="centered-container">
            <img src="/content/plugins/xplore-booking-plugin/dist/images/logo.png" />
            {updated ? (
                <h1>Booking Amended Successfully!</h1>
            ) : (
                <h1>Thank you for booking with Xplore More</h1>
            )}
            <div className="confirmation" style={{ textAlign: 'left' }}>
                {confirmations.map((confirmation, key) => {
                    return (
                        <p
                            key={key}
                            style={{ fontWeight: 600 }}
                            dangerouslySetInnerHTML={{ __html: confirmation }}
                        />
                    );
                })}
            </div>
            <br />
            <p>We hope you have an enjoyable journey to/from Edinburgh Airport.</p>
            <p>
                Please check your entire booking carefully and if you have any queries or questions
                regarding any of these details please call 01382 340006 / 7. Phone lines open Monday
                to Friday 9.30 - 5.00 and Saturday 10.00 - 4.00 Saturday.
                <br />
                <strong>
                    Please ensure that you arrive at the coach stance{' '}
                    <u>at least 10 minutes prior</u> to the time of departure as{' '}
                    <u>after this time your seat may be released to other customers</u>
                </strong>
            </p>

            <p>
                <strong>Scottish Concessionary Card Holders and Students</strong> <br />
                <strong>All Scottish Concessionary Card Holders</strong> must ensure cards are
                presented to the driver on boarding the Coach to obtain their concessionary tickets.
                If you do not have your Concessionary Card, your booking will be invalid and you
                will be required to pay the relevant standard fare for your journey.
            </p>
            <p>
                <strong>Students</strong> must show a current and valid matriculation card (or
                letter of acceptance) to the driver prior to boarding the coach. If you do not have
                a Student Card/Letter of Acceptance, your booking will be invalid and you will be
                required to pay the relevant standard fare for your journey.
            </p>
            <p>Details of your baggage allowance can be found on your Final Confirmation</p>
            <p>
                Terms and Conditions can be found on the
                <a href="//www.xploremore.co.uk/">xploremore.co.uk</a> website or by contacting our
                Travel Centre on 01382 340006 / 7.
            </p>

            <br />
            <a
                href="//www.xploremore.co.uk/"
                title="National Express Xplore Dundee"
                className="primary">
                Back to Xplore More Site
            </a>
            <button
                title="Print this page"
                className="primary"
                onClick={() => window.print()}
                style={{ marginLeft: `25px` }}>
                Print
            </button>
        </div>
    );
};

export default connect(
    null,
    { setRoute }
)(Confirmation);
