import React, { useState } from 'react';
import { connect } from 'react-redux';
import { setTerms } from '../../redux/actions';
import { getTotalCostFromCart } from '../../redux/selectors';
import BackButton from './BackButton';
import ContinueButton from './ContinueButton';
import JourneyDetails from './JourneyDetails';
import PriceBreakdown from './PriceBreakdown';
import Addons from './Addons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { VALIDATE_RECAPTCHA } from '../../config/endpoints';
import { GoogleReCaptchaProvider, GoogleReCaptcha } from 'react-google-recaptcha-v3';
import axios from 'axios';

const Cart = ({ totalPrice, setTerms, hideCart, step }) => {
    const [opened, setOpened] = useState(false);
    const [recaptcha, setRecaptcha] = useState(false);
    const cartOpen = opened ? 'open' : '';
    const rotation = opened ? 180 : null;
    const style = hideCart ? { display: 'none' } : null;

    const verifyRecaptcha = recaptchaToken => {
        axios
            .post(VALIDATE_RECAPTCHA, {
                recaptchaToken
            })
            .then(response => {
                // console.log('recaptcha response', response);
                if (response.data.success === true && response.data.score >= 0.5) {
                    setRecaptcha(true);
                } else {
                    setRecaptcha(false);
                }
            });

        // console.log('recaptchaToken', recaptchaToken);
    };

    return (
        <div className={`cart ${cartOpen}`} style={style}>
            <BackButton />
            <div className="content">
                <div className="heading">
                    <h2>Booking Details</h2>
                    <button onClick={() => setOpened(!opened)} className="open-cart">
                        <FontAwesomeIcon icon={['far', 'arrow-up']} rotation={rotation} />
                    </button>
                    <span className="price">£{totalPrice}</span>
                    <hr />
                </div>
                <div className="internal">
                    <JourneyDetails />
                    <PriceBreakdown />
                    <Addons />
                </div>
                <div className="terms">
                    <input
                        name="terms"
                        type="checkbox"
                        onChange={e => setTerms(e.target.checked)}
                        disabled={step === 5}
                    />
                    I have read and accept the{' '}
                    <a
                        href="https://nxbus.co.uk/dundee/legal/"
                        target="_blank"
                        rel="noopener noreferrer">
                        terms and conditions
                    </a>
                </div>
                <GoogleReCaptchaProvider reCaptchaKey="6LdRLWQcAAAAAGGnh9dpHhlaU4H_39nubLNnkbJF">
                    <GoogleReCaptcha onVerify={verifyRecaptcha} />
                    <ContinueButton recaptcha={recaptcha} />
                </GoogleReCaptchaProvider>
            </div>
        </div>
    );
};

const mapStateToProps = state => {
    const { journeyType, depart, departureDate, returnDate, inCart, hideCart } = state.cart;
    const { step } = state.route;
    const totalPrice = getTotalCostFromCart(state);
    return {
        journeyType,
        depart,
        departureDate,
        returnDate,
        inCart,
        totalPrice,
        hideCart,
        step
    };
};

export default connect(mapStateToProps, { setTerms })(Cart);
