<?php

namespace XploreBooking\Controller;

class AdminController
{

    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('wp_dashboard_setup', [$this, 'addWidgets']);
        add_action('init', [$this, 'printDriverManifest']);
        add_action('init', [$this, 'printBookingReport']);

        add_action('add_meta_boxes', [$this, 'yoast_is_toast'], 99);
        //add_action('wp_dashboard_setup', [$this, 'addTimeToJourneyDates']);
        //add_action('wp_dashboard_setup', [$this, 'addTimeToBookings']);
    }

    public function addWidgets()
    {
        $this->exportJourneyManifest();
        $this->exportBookingReport();
        $this->importBookings();

    }

    public function exportJourneyManifest()
    {
        global $wp_meta_boxes;
        wp_add_dashboard_widget('journey_manifest', 'Journey Manifest', [$this, 'JourneyManifest']);
    }

    public function exportBookingReport()
    {
        global $wp_meta_boxes;
        wp_add_dashboard_widget('booking_report', 'Booking Report', [$this, 'bookingReport']);
    }

    public function importBookings()
    {
        wp_add_dashboard_widget('booking_import', 'Booking Import', function () {
            $data = '<p>Please upload the desired csv:</p>';
            $data .= '
                <form action="" method="POST" id="bookingImport" name="bookingImport" enctype="multipart/form-data"> 
                    <input type="file" name="bookingCsv">
                    <input type="submit" value="Submit" name="importSubmit">
                </form>
            ';

            echo $data;
        });
    }

    public function bookingReport()
    {
        $data = '<p>Please enter the dates required:</p>';

        $data .= '
            <form action="" method="GET" id="journeySelectForm" name="journeySelectForm">
                <input type="date" name="startDate" placeholder="Please select the start date" required>
                <input type="date" name="endDate" placeholder="Please select the end date" required>
                <input type="submit" value="Get Report">
            </form>
        ';

        echo $data;
    }

    public function printBookingReport()
    {
        if (isset($_GET['startDate'])) {
            $startDate = $_GET['startDate'];
            $startDate = date('Ymd', strtotime($startDate));

            $endDate = $_GET['endDate'];
            $endDate = date('Ymd', strtotime($endDate));

            $outboundArgs = [
                'post_type' => 'booking',
                'post_status' => ['publish', 'private'],
                'posts_per_page' => -1,
                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key' => 'outbound_booking_time',
                        'compare' => '>=',
                        'value' => $startDate,
                    ],
                    [
                        'key' => 'outbound_booking_time',
                        'compare' => '<=',
                        'value' => $endDate,
                    ],
                ],
            ];
            $outboundBookings = get_posts($outboundArgs);

            $inboundArgs = [
                'post_type' => 'booking',
                'post_status' => ['publish', 'private'],
                'posts_per_page' => -1,
                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key' => 'inbound_booking_time',
                        'compare' => '>=',
                        'value' => $startDate,
                    ],
                    [
                        'key' => 'inbound_booking_time',
                        'compare' => '<=',
                        'value' => $endDate,
                    ],
                ],
            ];

            $inboundBookings = get_posts($inboundArgs);


            /** merge each booking on post ID's **/

            $bookings = [];
            foreach ($outboundBookings as $outboundBooking) {
                $bookings[$outboundBooking->ID] = $outboundBooking;
            }
            foreach ($inboundBookings as $inboundBooking) {
                $bookings[$inboundBooking->ID] = $inboundBooking;
            }

            if ($bookings) {
                self::outputBookingsCsv('booking-report.csv', $bookings);
            }
        }
    }

    public function outputBookingsCsv($fileName, $bookings)
    {
        $ticketTypes = TicketController::ticketTypes();
        $ticketRefArray = [];
        foreach ($ticketTypes as $key => $value) {
            $index = ucfirst(str_replace('-', ' ', $key));
            $ticketRefArray[] = $index;
        }

        ob_clean();
        header_remove();
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $fileName);

        $fp = fopen('php://output', 'w');
        $headerInitial = ["Name", "Phone Number", "Reservation Number", "Price", "Outbound Journey Direction", "Outbound Journey Time", "Outbound Journey Date", "Inbound Journey Direction", "Inbound Journey Time", "Inbound Journey Date", "Will you have extra luggage?", "Extra luggage Details", "Will you have oversized baggage?", "Oversized baggage detials"];
        $headerResult = array_merge($headerInitial, $ticketRefArray);

        fputcsv($fp, $headerResult);

        foreach ($bookings as $booking) {

            if (get_field('inbound_journey', $booking->ID)) {
                $inboundJourney = get_the_title(get_field('inbound_journey', $booking->ID)[0]);
                $inboundJourneyDirection = substr($inboundJourney, 0, 19);
                $inboundJourneyTime = substr($inboundJourney, 20, 4);
                $inboundJourneyDate = str_replace(' ', '/', substr($inboundJourney, 25, 10));
            }

            if (get_field('outbound_journey', $booking->ID)) {
                $outboundJourney = get_field('outbound_journey', $booking->ID);
                $outboundJourneyTitle = get_the_title($outboundJourney[0]);
                $outboundJourneyDirection = substr($outboundJourneyTitle, 0, 19);
                $outboundJourneyTime = substr($outboundJourneyTitle, 20, 4);
                $outboundJourneyDate = str_replace(' ', '/', substr($outboundJourneyTitle, 25, 10));
            }

            $tickets = get_field('tickets', $booking->ID);
            $ticketOutput = array_fill(0, count($ticketRefArray), 0);
            if ($tickets) {
                foreach ($tickets as $ticket) {
                    $ticketOutput[array_search($ticket['ticket_type'], $ticketRefArray)] = $ticket['quantity'];
                }
                $ticketsString = implode(',', $ticketOutput);
            } else {
                $ticketsString = '';
            }

            $extras = explode(',', get_field('add_ons', $booking->ID));
            $initial = [
                get_field('name', $booking->ID) . ' ' . get_field('surname', $booking->ID),
                get_field('phone_number', $booking->ID),
                get_field('payment_reference', $booking->ID),
                get_field('price', $booking->ID),
                $outboundJourneyDirection ?? "",
                $outboundJourneyTime ?? "",
                $outboundJourneyDate ?? "",
                $inboundJourneyDirection ?? "",
                $inboundJourneyTime ?? "",
                $inboundJourneyDate ?? "",
                $extras[0] ?? "",
                $extras[1] ?? "",
                $extras[2] ?? "",
                $extras[3] ?? "",
            ];

            $result = array_merge($initial, $ticketOutput);
            fputcsv($fp, $result);
        }
        fclose($fp);
        ob_flush();
        die;
    }

    public function JourneyManifest()
    {
        $data = '<p>Please enter the Journey Date:</p>';

        $data .= '
            <form action="" method="GET" id="journeySelectForm" name="journeySelectForm">
                <input type="date" name="journeyDate" placeholder="Please select the date" required>
                

                <input type="submit" value="Get Manifest">
            </form>
        ';

        echo $data;
    }

    public function printDriverManifest()
    {

        if (is_admin() && isset($_GET['journeyDate'])) {

            $date = $_GET['journeyDate'];
            // $date = date('d-m-Y', strtotime($date));

            $args = [
                'post_type' => 'journey-date',
                'posts_per_page' => -1,
                // 'name' => $slug,
                'meta_query' => [
                    [
                        'key' => 'date',
                        'compare' => '=',
                        'value' => $date,
                        'type' => "DATE",
                    ],
                ],
            ];

            $journeys = get_posts($args);

            $bookingData = [];
            foreach ($journeys as $journey) {
                $bookingArgs = [
                    'post_type' => 'booking',
                    'post_status' => ['publish', 'private'],
                    'posts_per_page' => -1,
                    'meta_query' => [
                        'relation' => 'OR',
                        [
                            'key' => 'inbound_journey',
                            'value' => '"' . $journey->ID . '"',
                            'compare' => 'LIKE',
                        ],
                        [
                            'key' => 'outbound_journey',
                            'value' => '"' . $journey->ID . '"',
                            'compare' => 'LIKE',
                        ],

                    ],
                ];

                $bookings = get_posts($bookingArgs);
                if ($bookings) {
                    $bookingData[] = self::getCsvData($bookings, $journey->post_title);
                }
            }

            $jTime = [];
            $jDirection = [];

            foreach ($bookingData as $bookings) {
                $jTime[] = $bookings[0]["journeyTime"];
                $jDirection[] = $bookings[0]["journeyDirection"];
            }

            array_multisort($jDirection, SORT_ASC, $jTime, SORT_ASC, $bookingData);

            self::outputCsv('manifest-' . $slug . '.csv', $bookingData);
        }
    }

    public function getCsvData($bookings, $journeyID)
    {
        $journeyData = [];
        foreach ($bookings as $booking) {
            $outboundReservation = get_field('outbound_reference', $booking->ID);
            $inboundReservation = get_field('inbound_reference', $booking->ID);
            $extras = explode(',', get_field('add_ons', $booking->ID));
            $tickets = get_field('tickets', $booking->ID);
            $numberOfPeople = self::getPeoplePerTicket($tickets);
            $phoneNo = get_field('phone_number', $booking->ID);

            $journeyDirection = substr($journeyID, 0, 19);
            $journeyTime = substr($journeyID, 20, 4);
            $journeyDate = substr($journeyID, 25, 10);

            $journeyData[] = [
                "journeyID" => $journeyID,
                "journeyDirection" => $journeyDirection,
                "journeyTime" => $journeyTime,
                "journeyDate" => str_replace(' ', '/', $journeyDate),
                "journeyName" => get_field('name', $booking->ID) . ' ' . get_field('surname', $booking->ID),
                "journeyPhoneNo" => $phoneNo,
                "journeyOutbound" => $outboundReservation,
                "journeyImbound" => $inboundReservation,
                "journeyNoOfPeople" => $numberOfPeople,
                "journeyPaymentRef" => get_field('payment_reference', $booking->ID),
                "journeyExtra1" => $extras[0]??"",
                "journeyExtra2" => $extras[1]??"",
                "journeyExtra3" => $extras[2]??"",
                "journeyExtra4" => $extras[3]??"",
                "journeyPaymentDetails" => get_field('agent_payment_details', $booking->ID),
            ];

        }
        return $journeyData;
    }

	public function outputCsv($fileName, $journeyData)
    {

        ob_clean();
        header_remove();
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $fileName);
        $fp = fopen('php://output', 'w');

        set_time_limit(60);
        $noOfJourney = 0;
        foreach ($journeyData as $bookings) {

            fputcsv($fp, ["Journey Direction","Journey Time","Journey Date","Name", "Phone Number", "Outbound Reservation Number", "Inbound Reservation Number", "Seats", "Will you have extra luggage?", "Extra luggage Details", "Will you have oversized baggage?", "Oversized baggage details", "Booking notes"]);

            foreach($bookings as $booking) {

                fputcsv($fp,
                [
                $booking["journeyDirection"],
                $booking["journeyTime"],
                $booking["journeyDate"],
                $booking["journeyName"],
                $booking["journeyPhoneNo"],
                $booking["journeyOutbound"],
                $booking["journeyInbound"]??"",
                $booking["journeyNoOfPeople"],
                $booking["journeyExtra1"],
                $booking["journeyExtra2"]??"",
                $booking["journeyExtra3"]??"",
                $booking["journeyExtra4"]??"",
                $booking["journeyPaymentDetails"]]);

            }

            $noOfJourney++;
            fputcsv($fp, [""]);
        }
        fclose($fp);
        ob_flush();
        die;
    }

    public static function getPeoplePerTicket($tickets)
    {

        $ticketsSold = 0;
        foreach ($tickets as $ticket) {
            $hasInt = (int)filter_var($ticket['ticket_type'], FILTER_SANITIZE_NUMBER_INT);

            if ($hasInt != 0) {
                $ticketsSold += ($hasInt * (int)$ticket['quantity']);
            } else {
                switch ($ticket['ticket_type']) {
                    case 'Family' :
                        $ticketsSold += (4 * (int)$ticket['quantity']);
                        break;
                    default :
                        $ticketsSold += (1 * (int)$ticket['quantity']);
                        break;
                }
            }
        }
        return $ticketsSold;
    }

    function yoast_is_toast(){
        remove_meta_box('wpseo_meta', 'journey-date', 'normal');
        remove_meta_box('wpseo_meta', 'booking', 'normal');
        remove_meta_box('wpseo_meta', 'journey', 'normal');
        remove_meta_box('wpseo_meta', 'ticket', 'normal');
    }

    public function addTimeToJourneyDates()
    {

        $args = [
            'post_type'         => 'journey-date',
            'posts_per_page'    => -1,
            'meta_query'       => [
                [
                    'key'      => 'departure_time',
                    'compare'  => 'NOT EXISTS'
                ]
            ]
        ];

        $journeyDates = get_posts($args);

        foreach($journeyDates as $journey){
            //get time from the title
            $journeyTitle = $journey->post_title;
            $journeyTime = substr($journeyTitle,20,4);

            //Format the time
            $journeyTime = substr_replace($journeyTime, ":", 2, 0);
            $journeyTime = substr_replace($journeyTime, ":00", 5, 0);

            //Get ID
            $journeyIdent = $journey->ID;

            //set the departure time to that time
            update_field('departure_time', $journeyTime, $journeyIdent);
        }
    }

    public function addTimeToBookings()
    {

        $args = [
            'post_type'         => 'booking',
            'posts_per_page'    => -1,
            'post_status'       => 'publish',
            'meta_query'       => [
                [
                    'key'      => 'departure_time',
                    'compare'  => '=',
                    'value'    => '',
                ]
            ]
        ];

        $bookingDates = get_posts($args);

        foreach($bookingDates as $booking){

            $bookingField = get_field('outbound_journey', $booking->ID);
            $outboundJourney = get_post($bookingField[0])->post_title;

            //get time from the outbound reference
            $bookingTime = substr($outboundJourney,20,4);

            //Format the time
            $bookingTime = substr_replace($bookingTime, ":", 2, 0);
            $bookingTime = substr_replace($bookingTime, ":00", 5, 0);

            //Get ID
            $bookingIdent = $booking->ID;

            //set the departure time to that time
            update_field('departure_time', $bookingTime, $bookingIdent);
        }
    }
}
