import React from 'react';
import { connect } from 'react-redux';
import { previousRoute } from '../../redux/actions';
import { withRouter } from 'react-router-dom';

const NoResults = ({ history, previousRoute }) => (
    <p>
        No results found for the selected time.
        <button
            onClick={() => {
                history.goBack();
                previousRoute();
            }}>
            Back to Search
        </button>
    </p>
);

export default connect(
    null,
    { previousRoute }
)(withRouter(NoResults));
