import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { updateAddons, setRoute } from '../redux/actions';

class AddOns extends Component {
    constructor(props) {
        super(props);
    }

    componentDidMount() {
        this.props.setRoute(3);
    }

    updateUserDetail = e => {
        this.props.updateAddons(e.target);
    };

    render() {
        const {
            additionalLuggageChecked,
            luggageDescription,
            oversizedLuggage,
            oversizedDescription
        } = this.props;

        return (
            <div className="addons">
                <h1>Add ons</h1>
                <p>
                    Luggage allowance is 1 large suitcase with a maximum weight of 23kg and
                    dimensions of no more than 75cm x 50cm x 32cm, or two medium suitcases per
                    person with a maximum combined weight of 23kg and dimensions of no more than
                    70cm x 45cm x 30cm."
                </p>
                <div className="content">
                    <p>
                        <strong>Will you have extra luggage?</strong>
                    </p>
                    <div className="radio-input">
                        <input
                            type="radio"
                            name="additionalLuggageChecked"
                            value="yes"
                            checked={additionalLuggageChecked === 'yes'}
                            onChange={this.updateUserDetail}
                        />
                        Yes
                    </div>
                    <div className="radio-input">
                        <input
                            type="radio"
                            name="additionalLuggageChecked"
                            value="no"
                            checked={additionalLuggageChecked === 'no'}
                            onChange={this.updateUserDetail}
                        />
                        No
                    </div>
                    <br />
                    <p className="small-text">
                        The additional cost for each extra luggage is £10 per item, per journey.
                        This will be paid upon your arrival at the bus
                    </p>
                    <br />
                    {additionalLuggageChecked === 'yes' && (
                        <>
                            <p>Please let us know the amount of extra luggage you will have.</p>
                            <br />
                            <textarea
                                name="luggageDescription"
                                placeholder={
                                    luggageDescription === ''
                                        ? 'Please enter brief description...'
                                        : undefined
                                }
                                defaultValue={luggageDescription}
                                onBlur={this.updateUserDetail}
                            />
                            <br />
                        </>
                    )}
                    <p>
                        <strong>Will you have oversized baggage?</strong>
                    </p>
                    <div className="radio-input">
                        <input
                            type="radio"
                            name="oversizedLuggage"
                            value="yes"
                            checked={oversizedLuggage === 'yes'}
                            onChange={this.updateUserDetail}
                        />
                        Yes
                    </div>
                    <div className="radio-input">
                        <input
                            type="radio"
                            name="oversizedLuggage"
                            value="no"
                            checked={oversizedLuggage === 'no'}
                            onChange={this.updateUserDetail}
                        />
                        No
                    </div>
                    <br />
                    {oversizedLuggage === 'yes' && (
                        <>
                            <p>Please let us know the amount of extra luggage you will have.</p>
                            <textarea
                                name="oversizedDescription"
                                placeholder={
                                    oversizedDescription === ''
                                        ? 'Please enter brief description...'
                                        : undefined
                                }
                                defaultValue={oversizedDescription}
                                onBlur={this.updateUserDetail}
                            />
                            <br />
                        </>
                    )}
                </div>
            </div>
        );
    }
}

AddOns.propTypes = {
    context: PropTypes.object
};

const mapStateToProps = state => ({ ...state.cart.addons });

export default connect(
    mapStateToProps,
    { updateAddons, setRoute }
)(AddOns);
