import React, { Component } from 'react';

import { BrowserRouter } from 'react-router-dom';
import { Header, Footer, MainView, Cart } from './components';
import { ToastContainer, Slide } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.min.css';
import './config/FontAwesomeLibrary';
import { loadReCaptcha } from 'react-recaptcha-v3';
import { connect } from 'react-redux';

class BookingApp extends Component {
    constructor(props) {
        super(props);
    }

    componentDidMount() {
        loadReCaptcha('6LdOoMgUAAAAAGBN6j_EZt_wf8e_MCSlWMFQhDET');
    }

    render() {
        return (
            <div className="container">
                <BrowserRouter>
                    <Header />
                    <div className="row">
                        <MainView />
                        {this.props.step !== 6 && <Cart />}
                    </div>
                    <Footer />
                </BrowserRouter>
                <ToastContainer
                    position="top-center"
                    autoClose={3000}
                    hideProgressBar
                    newestOnTop
                    transition={Slide}
                    closeOnClick
                    rtl={false}
                    pauseOnVisibilityChange
                    draggable
                    pauseOnHover={false}
                />
            </div>
        );
    }
}

const mapStateToProps = state => ({
    step: state.route.step
});

export default connect(mapStateToProps)(BookingApp);
