// global params

import React, { Component } from 'react';
import axios from 'axios';
import Loader from 'react-loader-spinner';
import { connect } from 'react-redux';
import { toast } from 'react-toastify';
import { ADD_NEW_BOOKING, CHECK_LOGIN, SET_NOTES } from './../config/endpoints';
import { addBooking, setRoute } from '../redux/actions';
import { getTotalSeatsFromCart, getTotalCostFromCart } from '../redux/selectors';
import { base } from '../routes';

class Payment extends Component {
    constructor(props) {
        super(props);

        this.state = {
            redirect: false,
            agent: null
        };
        this.formRef = React.createRef();
    }

    componentDidMount() {
        this.props.setRoute(5);
        this.addBooking();
        axios.post(CHECK_LOGIN).then(response => {
            console.log(response);
            if (response.data === true) {
                this.setState({
                    agent: true
                });
            } else {
                this.setState({
                    agent: false
                });
            }
        });
    }

    addBooking = () => {
        const { firstName, surname, email, phoneNumber } = this.props.user;
        const { inCart, addons, seats, price } = this.props;
        const outbound = this.props.outbound !== null && this.props.outbound.slug;
        const inbound = this.props.inbound !== null && this.props.inbound.slug;
        axios
            .post(ADD_NEW_BOOKING, {
                firstName,
                surname,
                email,
                phoneNumber,
                outbound,
                inbound,
                addons,
                seats,
                inCart,
                price
            })
            .then(response => {
                const bookingId = response.data;
                this.props.addBooking(bookingId);
                this.setState({ redirect: true, bookingId });
            })
            .catch(error => {
                toast.error(error.response.data);
                console.error('Create booking:', error);
            });
    };

    redirectWorldPay = () => {
        const form = this.formRef.current;
        form.submit();
    };

    skipPayment = () => {
        axios
            .post(SET_NOTES, {
                notes: this.state.notes,
                bookingId: this.state.bookingId
            })
            .then(response => {
                this.props.history.push(`${base}/complete/${this.state.bookingId}`);
            })
            .catch(error => {
                console.error(error);
            });
    };

    componentDidUpdate() {
        if (this.props.bookingId !== null && this.state.agent === false) {
            this.redirectWorldPay();
        }
    }

    proceedToPayment = () => {
        if (window.confirm('Are you sure you want to leave, you cannot return to this stage?')) {
            this.redirectWorldPay();
        }
    };
    render() {
        return (
            <div className="choose-journey">
                <h1>Payment</h1>
                {this.state.agent === null && (
                    <Loader type="Oval" width={50} height={50} color="#088584" />
                )}
                {this.props.bookingId !== null && (
                    <>
                        <form
                            action="https://secure-test.worldpay.com/wcc/purchase"
                            method="POST"
                            ref={this.formRef}>
                            <input type="hidden" name="testMode" value="100" />
                            <input type="hidden" name="instId" value="1357697" />
                            <input type="hidden" name="cartId" value={this.props.bookingId} />
                            <input type="hidden" name="amount" value={this.props.price} />
                            <input type="hidden" name="currency" value="GBP" />
                        </form>
                    </>
                )}

                {this.state.agent === true && this.state.recaptcha && (
                    <>
                        <textarea
                            name="notes"
                            id="notes"
                            cols="30"
                            rows="10"
                            onChange={e => this.setState({ notes: e.target.value })}
                            placeholder="Please enter any notes for this order"
                        />
                        <button
                            className="primary continue-button invalid"
                            onClick={this.skipPayment}>
                            Skip Payment Gateway
                        </button>
                        <button
                            className="primary continue-button invalid"
                            onClick={this.proceedToPayment}>
                            Proceed to payment
                        </button>
                    </>
                )}
            </div>
        );
    }
}

const mapStateToProps = state => {
    const { outbound, inbound, addons, inCart } = state.cart;
    const seats = getTotalSeatsFromCart(state);
    const price = getTotalCostFromCart(state);

    return {
        bookingId: state.booking.bookingId,
        user: state.user,
        outbound,
        inbound,
        addons,
        seats,
        inCart,
        price
    };
};

export default connect(
    mapStateToProps,
    { addBooking, setRoute }
)(Payment);
