import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { progressRoute } from './../../redux/actions';
import { checkValidStep } from '../../redux/selectors';
import Routes from '../../routes';
import { toast } from 'react-toastify';
import { ReCaptcha } from 'react-recaptcha-v3';
import { VALIDATE_RECAPTCHA } from '../../config/endpoints';
import axios from 'axios';

class ContinueButton extends Component {
    constructor(props) {
        super(props);

        this.state = {
            recaptcha: false
        };
    }

    componentDidMount() {}

    verifyRecaptcha = recaptchaToken => {
        axios
            .post(VALIDATE_RECAPTCHA, {
                recaptchaToken
            })
            .then(response => {
                console.log(response);
                if (response.data.success === true && response.data.score >= 0.5) {
                    this.setState({
                        recaptcha: true
                    });
                } else {
                    this.setState({
                        recaptcha: false
                    });
                }
            });
    };

    render() {
        const { history, step, continueDisable, progressRoute, valid } = this.props;
        return (
            <>
                <ReCaptcha
                    sitekey="6LdOoMgUAAAAAGBN6j_EZt_wf8e_MCSlWMFQhDET"
                    action="payment"
                    verifyCallback={this.verifyRecaptcha}
                />
                <button
                    disabled={continueDisable}
                    className={
                        valid.status && (step != 4 || (step == 4 && this.state.recaptcha))
                            ? 'primary continue-button'
                            : 'primary continue-button invalid'
                    }
                    onClick={() => {
                        if (valid.status) {
                            if (step != 4 || (step == 4 && this.state.recaptcha)) {
                                history.push(Routes[step].path);
                                progressRoute();
                            } else {
                                toast.error(
                                    'There was an issue validating your session. Please refresh your broswer and try again'
                                );
                            }
                        } else {
                            toast.error(valid.message);
                        }
                    }}>
                    {valid.status && step == 4 ? 'Confirm and Pay' : 'Continue'}
                </button>
            </>
        );
    }
}

const mapStateToProps = state => {
    const valid = checkValidStep(state);
    return {
        step: state.route.step,
        continueDisable: state.route.continueDisable,
        valid
    };
};
export default connect(
    mapStateToProps,
    { progressRoute }
)(withRouter(ContinueButton));

/*
const ContinueButton = ({ history, step, continueDisable, progressRoute, valid }) => (
    <>
        <ReCaptcha
            sitekey="6LdOoMgUAAAAAGBN6j_EZt_wf8e_MCSlWMFQhDET"
            action={step}
            verifyCallback={this.verifyCallback}
        />
        <button
            disabled={continueDisable}
            className={valid.status ? 'primary continue-button' : 'primary continue-button invalid'}
            onClick={() => {
                if (valid.status) {
                    history.push(Routes[step].path);
                    progressRoute();
                } else {
                    toast.error(valid.message);
                }
            }}>
            {valid.status && step == 4 ? 'Confirm and Pay' : 'Continue'}
        </button>
    </>
);

const mapStateToProps = state => {
    const valid = checkValidStep(state);
    return {
        step: state.route.step,
        continueDisable: state.route.continueDisable,
        valid
    };
};
export default connect(
    mapStateToProps,
    { progressRoute }
)(withRouter(ContinueButton));*/
