import React, { useState, useEffect } from 'react';
import { GET_POLICY } from '../config/endpoints';
import CardLogos from '../images/cardlogos.png';
import axios from 'axios';

const Footer = () => {
    const [policy, setPolicy] = useState('');

    async function fetchData() {
        axios
            .get(GET_POLICY)
            .then(response => {
                setPolicy(response.data);
            })
            .catch(err => console.warn(err));
    }

    useEffect(() => {
        fetchData();
    });

    return (
        <>
            <div className="footer">
                <ul>
                    <li>
                        <a
                            href={policy}
                            target="_blank"
                            rel="noopener noreferrer"
                            title="Site Policy">
                            Refund Policy
                        </a>
                    </li>
                    <li>
                        <a
                            href={policy}
                            target="_blank"
                            rel="noopener noreferrer"
                            title="Site Policy">
                            Delivery Policy
                        </a>
                    </li>
                </ul>
                <img src={CardLogos} alt="Xplore Card Logos" />
                <p>We only accept payment in GBP</p>
                <p className="company">
                    Tayside Public Transport Co Ltd, 44-48 East Dock Street, Dundee, DD1 3JS.
                    Company No. Scotland 97606. Trading as Xplore Dundee. VAT Registration No.
                    561/6683-22
                </p>
            </div>
        </>
    );
};
export default Footer;
