import React, { Component } from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { progressRoute } from './../../redux/actions';
import { checkValidStep } from '../../redux/selectors';
import Routes from '../../routes';
import { toast } from 'react-toastify';
import { ReCaptcha } from 'react-recaptcha-v3';

class ContinueButton extends Component {
    constructor(props) {
        super(props);
    }

    componentDidMount() {}

    render() {
        const { history, step, continueDisable, progressRoute, valid } = this.props;
        return (
            <>
                {valid.status && (
                    <ReCaptcha sitekey="6LdOoMgUAAAAAGBN6j_EZt_wf8e_MCSlWMFQhDET" action={step} />
                )}
                <button
                    disabled={continueDisable}
                    className={
                        valid.status ? 'primary continue-button' : 'primary continue-button invalid'
                    }
                    onClick={() => {
                        if (valid.status) {
                            history.push(Routes[step].path);
                            progressRoute();
                        } else {
                            toast.error(valid.message);
                        }
                    }}>
                    {valid.status && step == 4 ? 'Confirm and Pay' : 'Continue'}
                </button>
            </>
        );
    }
}

const mapStateToProps = state => {
    const valid = checkValidStep(state);
    return {
        step: state.route.step,
        continueDisable: state.route.continueDisable,
        valid
    };
};
export default connect(
    mapStateToProps,
    { progressRoute }
)(withRouter(ContinueButton));

/*
const ContinueButton = ({ history, step, continueDisable, progressRoute, valid }) => (
    <>
        <ReCaptcha
            sitekey="6LdOoMgUAAAAAGBN6j_EZt_wf8e_MCSlWMFQhDET"
            action={step}
            verifyCallback={this.verifyCallback}
        />
        <button
            disabled={continueDisable}
            className={valid.status ? 'primary continue-button' : 'primary continue-button invalid'}
            onClick={() => {
                if (valid.status) {
                    history.push(Routes[step].path);
                    progressRoute();
                } else {
                    toast.error(valid.message);
                }
            }}>
            {valid.status && step == 4 ? 'Confirm and Pay' : 'Continue'}
        </button>
    </>
);

const mapStateToProps = state => {
    const valid = checkValidStep(state);
    return {
        step: state.route.step,
        continueDisable: state.route.continueDisable,
        valid
    };
};
export default connect(
    mapStateToProps,
    { progressRoute }
)(withRouter(ContinueButton));*/
