import React from 'react';
import { Switch, Route } from 'react-router-dom';
import posed, { PoseGroup } from 'react-pose';

import Routes from '../routes';

const RoutesContainer = posed.div({
    enter: {
        opacity: 1,
        delay: 100,
        beforeChildren: true
    },
    exit: { opacity: 0 }
});

const MainView = () => (
    <div className="main-view">
        <Route
            render={({ location }) => (
                <PoseGroup>
                    <RoutesContainer key={location.pathname}>
                        <Switch location={location}>
                            {Routes.map((route, index) => (
                                <Route
                                    exact={true}
                                    path={route.path}
                                    component={route.component}
                                    key={index}
                                />
                            ))}
                        </Switch>
                    </RoutesContainer>
                </PoseGroup>
            )}
        />
    </div>
);

export default MainView;
