<?php

namespace XploreBooking\Controller;

class AdminController
{


    public function __construct()
    {
        $this->registerActions();
    }

    private function registerActions()
    {
        add_action('wp_dashboard_setup', [$this, 'exportJourneyManifest']);
        add_action('init', [$this, 'printDriverManifest']);

        add_action('wp_dashboard_setup', [$this, 'exportBookingReport']);
        add_action('init', [$this, 'printBookingReport']);

    }

    public function exportBookingReport()
    {
        global $wp_meta_boxes;
        wp_add_dashboard_widget('booking_report', 'Booking Report', [$this, 'bookingReport']);
    }

    public function bookingReport()
    {
        $data = '<p>Please enter the dates required:</p>';

        $data .= '
            <form action="" method="GET" id="journeySelectForm" name="journeySelectForm">
                <input type="date" name="startDate" placeholder="Please select the start date" required>
                <input type="date" name="endDate" placeholder="Please select the end date" required>
                <input type="submit" value="Get Report">
            </form>
        ';

        echo $data;
    }

    public function printBookingReport()
    {
        if (isset($_GET['startDate'])) {
            $startDate = $_GET['startDate'];
            $startDate = date('Ymd', strtotime($startDate));

            $endDate = $_GET['endDate'];
            $endDate = date('Ymd', strtotime($endDate));

            $args = [
                'post_type' => 'booking',
                'posts_per_page' => -1,
                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key' => 'outbound_booking_time',
                        'compare' => '>=',
                        'value' => $startDate,
                    ],
                    [
                        'key' => 'inbound_booking_time',
                        'compare' => '<=',
                        'value' => $endDate,
                    ],
                ],
            ];

            $bookings = get_posts($args);
            if ($bookings) {
                self::outputBookingsCsv('booking-report.csv', $bookings);
            }
        }
    }

    public function exportJourneyManifest()
    {
        global $wp_meta_boxes;
        wp_add_dashboard_widget('journey_manifest', 'Journey Manifest', [$this, 'JourneyManifest']);
    }

    public function JourneyManifest()
    {
        $data = '<p>Please enter the Journey Date:</p>';

        $data .= '
            <form action="" method="GET" id="journeySelectForm" name="journeySelectForm">
                <input type="date" name="journeyDate" placeholder="Please select the date" required>
                <select name="time" required>
                    <option value="0230">02:30</option>
                    <option value="0400">04:00</option>
                    <option value="0530">05:30</option>
                    <option value="0700">07:00</option>
                    <option value="0830">08:30</option>
                    <option value="1000">10:00</option>
                    <option value="1130">11:30</option>
                    <option value="1300">13:00</option>
                    <option value="1430">14:30</option>
                    <option value="1600">16:00</option>
                    <option value="1730">17:30</option>
                    <option value="1900">19:00</option>
                    <option value="2030">20:30</option>
                    <option value="2200">22:00</option>
                    <option value="2330">23:30</option>
                    <option value="0100">01:00</option>
                </select>
                <select name="direction" placeholder="Please select the direction" required>
                    <option value="dundee-to-edinburgh">Dundee</option>
                    <option value="edinburgh-to-dundee">Edinburgh Airport</option>
                </select>

                <input type="submit" value="Get Manifest">
            </form>
        ';

        echo $data;
    }

    public function printDriverManifest()
    {

        if (isset($_GET['journeyDate'])) {
            $date = $_GET['journeyDate'];
            $time = $_GET['time'];
            $direction = $_GET['direction'];

            $date = date('d-m-Y', strtotime($date));

            $slug = $direction . '-' . $time . '-' . $date;

            $args = [
                'post_type' => 'journey-date',
                'posts_per_page' => -1,
                'name' => $slug,
            ];

            $journey = get_posts($args);
            $bookingArgs = [
                'post_type' => 'booking',
                'posts_per_page' => -1,
                'meta_query' => [
                    'relation' => 'OR',
                    [
                        'key' => 'inbound_journey',
                        'value' => '"' . $journey[0]->ID . '"',
                        'compare' => 'LIKE',
                    ],
                    [
                        'key' => 'outbound_journey',
                        'value' => '"' . $journey[0]->ID . '"',
                        'compare' => 'LIKE',
                    ],

                ],
            ];
            $bookings = get_posts($bookingArgs);
            if ($bookings) {
                self::outputCsv('manifest-' . $slug . '.csv', $bookings);
            }
        }
    }

	public function outputCsv($fileName, $bookings)
    {
        ob_clean();
        header_remove();
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $fileName);
        $fp = fopen('php://output', 'w');

        fputcsv($fp, ["Name", "Phone Number", "Outbound Reservation Number", "Inbound Reservation Number", "Seats", "Payment Reference", "Will you have extra luggage?", "Extra luggage Details", "Will you have oversized baggage?", "Oversized baggage detials"]);
        foreach ($bookings as $booking) {

            $outboundReservation = get_field('outbound_reference', $booking->ID);
            $inboundReservation = get_field('inbound_reference', $booking->ID);
            $extras = explode(',', get_field('add_ons', $booking->ID));
            $tickets = get_field('tickets', $booking->ID);
            $numberOfPeople = self::getPeoplePerTicket($tickets);
            fputcsv($fp, [get_field('name', $booking->ID) . ' ' . get_field('surname', $booking->ID), get_field('phone_number', $booking->ID), $outboundReservation, $inboundReservation, $numberOfPeople, get_field('payment_reference', $booking->ID), $extras[0], $extras[1], $extras[2], $extras[3]]);
        }
        fclose($fp);
        ob_flush();
        die;
    }

    public function getPeoplePerTicket($tickets)
    {

        $ticketsSold = 0;
        foreach ($tickets as $ticket) {
            $hasInt = (int) filter_var($ticket['ticket_type'], FILTER_SANITIZE_NUMBER_INT);

            if($hasInt != 0) {
                $ticketsSold += ($hasInt * (int) $ticket['quantity']);
            } else {
                switch ($ticket['ticket_type']){
                    case 'Family' :
                        $ticketsSold += (4 * (int) $ticket['quantity']);
                        break;
                    default :
                        $ticketsSold += (1 * (int) $ticket['quantity']);
                        break;
                }
            }
        }
        return $ticketsSold;
    }

    public function outputBookingsCsv($fileName, $bookings)
    {
        $ticketTypes = TicketController::ticketTypes();
        $ticketRefArray = [];
        foreach($ticketTypes as $key => $value) {
            $index = ucfirst(str_replace('-', ' ', $key));
            $ticketRefArray[] = $index;
        }
        ob_clean();
        header_remove();
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment;filename=' . $fileName);

        $fp = fopen('php://output', 'w');
        $headerInitial = ["Name", "Phone Number", "Reservation Number", "Price", "Outbound Journey", "Inbound Journey", "Will you have extra luggage?", "Extra luggage Details", "Will you have oversized baggage?", "Oversized baggage detials"];
        $headerResult = array_merge($headerInitial, $ticketRefArray);
        fputcsv($fp, $headerResult);

        foreach ($bookings as $booking) {
            $outboundJourney = get_field('outbound_journey', $booking->ID);
            $inboundJourney = get_field('inbound_journey', $booking->ID);
            $tickets = get_field('tickets', $booking->ID);
            $ticketOutput = array_fill(0, count($ticketRefArray), 0);
            foreach ($tickets as $ticket) {
                $ticketOutput[array_search($ticket['ticket_type'], $ticketRefArray)] = $ticket['quantity'];
            }
            $ticketsString = implode(',', $ticketOutput);
            $extras = explode(',', get_field('add_ons', $booking->ID));
            $initial = [get_field('name', $booking->ID) . ' ' . get_field('surname', $booking->ID), get_field('phone_number', $booking->ID), get_field('payment_reference', $booking->ID),get_field('price', $booking->ID), get_the_title($outboundJourney[0]), get_the_title($inboundJourney[0]), $extras[0], $extras[1], $extras[2], $extras[3]];
            $result = array_merge($initial, $ticketOutput);
            fputcsv($fp, $result);
        }
        fclose($fp);
        ob_flush();
        die;
    }

}
