import React, { useState, useEffect } from 'react';
import axios from 'axios';
import { GET_CONFIRMATION_TEXT } from '../config/endpoints';
import { setRoute } from '../redux/actions';
import { connect } from 'react-redux';

const Confirmation = ({ match, setRoute }) => {
    const [confirmations, setConfirmations] = useState([]);
    setRoute(6);
    async function fetchData() {
        const bookingId = match.params.bookingId;
        if (bookingId === null) return null;
        axios
            .get(GET_CONFIRMATION_TEXT, {
                params: {
                    bookingId
                }
            })
            .then(response => {
                setConfirmations(response.data);
            })
            .catch(err => console.warn(err));
    }

    useEffect(() => {
        fetchData();
    }, []);

    return (
        <div className="centered-container">
            <h1>Thank you for booking with Xplore More</h1>
            <div className="confirmation" style={{ textAlign: 'left' }}>
                {confirmations.map((confirmation, key) => {
                    return (
                        <p
                            key={key}
                            style={{ fontWeight: 600 }}
                            dangerouslySetInnerHTML={{ __html: confirmation }}
                        />
                    );
                })}
            </div>
            <br />
            <p>We hope you have an enjoyable journey to/from Edinburgh Airport.</p>
            <p>
                If you have any queries or questions regarding your booking please call 01382 201121
                during office hours 9 - 5.
            </p>
            <p>
                Monday to Friday Outwith these hours please call the National Express helpline
                number on 0871 781 8181 and they will be more than happy to assist you in your
                enquiry
            </p>
            <p>
                <strong>
                    Please ensure that you arrive at the coach stance at least 10 minutes prior to
                    the time of departure as after this time your seat may be released to other
                    customers
                </strong>
            </p>
            <p>
                <strong>Scottish Concessionary Card Holders</strong> <br />
                All Scottish Concessionary Card Holders must ensure that they present their cards to
                the driver and scan them on the ticket machines to obtain their concessionary
                tickets. If you are unable to present your concessionary card you will be asked to
                pay the relevant standard fare for your journey.
            </p>
            <p>
                <strong>Students</strong> <br />
                Students should ensure that they have a current and valid matriculation card or
                letter of acceptance at a college/university available to show to the driver prior
                to boarding the coach.
            </p>
            <br />
            <a
                href="//www.xploremore.co.uk/"
                title="National Express Xplore Dundee"
                className="primary">
                Back to Xplore More Site
            </a>
            <button
                title="Print this page"
                className="primary"
                onClick={() => window.print()}
                style={{ marginLeft: `25px` }}>
                Print
            </button>
        </div>
    );
};

export default connect(
    null,
    { setRoute }
)(Confirmation);
