import * as ACTIONS from './actionTypes';

//CART
export const changeJourneyType = type => ({
    type: ACTIONS.CHANGE_JOURNEY_TYPE,
    payload: {
        type
    }
});

export const changeDirection = () => ({
    type: ACTIONS.CHANGE_DIRECTION
});

export const setDepartureDate = date => ({
    type: ACTIONS.SET_DEPARTURE_DATE,
    payload: {
        date
    }
});

export const setReturnDate = date => ({
    type: ACTIONS.SET_RETURN_DATE,
    payload: {
        date
    }
});

export const addTicketToCart = ticket => ({
    type: ACTIONS.ADD_TICKET_TO_CART,
    payload: ticket
});

export const removeTicketFromCart = id => ({
    type: ACTIONS.REMOVE_TICKET_FROM_CART,
    payload: id
});

export const updateAddons = field => ({
    type: ACTIONS.UPDATE_ADDONS,
    payload: {
        key: field.name,
        value: field.value
    }
});

export const setTerms = value => ({
    type: ACTIONS.SET_TERMS,
    payload: value
});

export const addJourney = (journey, direction) => ({
    type: ACTIONS.ADD_JOURNEY,
    payload: {
        journey,
        direction
    }
});

export const hideCart = value => ({
    type: ACTIONS.HIDE_CART,
    payload: value
});

export const removeJourneys = () => ({
    type: ACTIONS.REMOVE_JOURNEYS
});

//TICKETS
export const addTickets = tickets => ({
    type: ACTIONS.ADD_TICKETS,
    payload: tickets
});

//USER
export const updateUser = field => ({
    type: ACTIONS.UPDATE_USER,
    payload: {
        key: field.name,
        value: field.value
    }
});

//ROUTE
export const progressRoute = () => ({
    type: ACTIONS.PROGRESS_ROUTE
});

export const previousRoute = () => ({
    type: ACTIONS.PREVIOUS_ROUTE
});

export const setRoute = step => ({
    type: ACTIONS.SET_ROUTE,
    payload: step
});
//BOOKING
export const addBooking = bookingId => ({
    type: ACTIONS.ADD_BOOKING,
    payload: {
        bookingId
    }
});
