import React from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { previousRoute } from './../../redux/actions';

const BackButton = ({ history, previousRoute, location }) => {
    return (
        <div className="back-button">
            {location.pathname !== '/booking/' &&
                !location.pathname.includes('/booking/complete/') && (
                    <button
                        className="dark"
                        onClick={() => {
                            history.goBack();
                            previousRoute();
                        }}>
                        Back
                    </button>
                )}
        </div>
    );
};

export default connect(
    null,
    { previousRoute }
)(withRouter(BackButton));
