import React from 'react';
import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';
import { progressRoute } from './../../redux/actions';
import { checkValidStep } from '../../redux/selectors';
import Routes from '../../routes';
import { toast } from 'react-toastify';

const ContinueButton = ({ history, step, continueDisable, progressRoute, valid }) => (
    <button
        disabled={continueDisable}
        className={valid.status ? 'primary continue-button' : 'primary continue-button invalid'}
        onClick={() => {
            if (valid.status) {
                history.push(Routes[step].path);
                progressRoute();
            } else {
                toast.error(valid.message);
            }
        }}>
        {valid.status && step == 4 ? 'Confirm and Pay' : 'Continue'}
    </button>
);

const mapStateToProps = state => {
    const valid = checkValidStep(state);
    return {
        step: state.route.step,
        continueDisable: state.route.continueDisable,
        valid
    };
};
export default connect(
    mapStateToProps,
    { progressRoute }
)(withRouter(ContinueButton));
