import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

const Addons = ({ additionalLuggageChecked, oversizedLuggage }) => {
    if (additionalLuggageChecked !== 'yes' && oversizedLuggage !== 'yes') return null;

    return (
        <div className="additional-cost">
            <p>
                <b>Additional Cost</b>
            </p>
            {additionalLuggageChecked === 'yes' && <p>Extra Luggage</p>}
            {oversizedLuggage === 'yes' && <p>Oversized Luggage</p>}
            <p className="small-text">
                * The additional cost for each extra luggage is £10 per item, per journey. This will
                be paid upon your arrival at the bus
            </p>
        </div>
    );
};

Addons.propTypes = {
    additionalLuggageChecked: PropTypes.string,
    oversizedLuggage: PropTypes.string
};

export default connect(state => ({
    ...state.cart.addons
}))(Addons);
